package com.bcxin.platform.dto.attend;

import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.domain.attend.AttendLeave;
import com.bcxin.platform.domain.attend.AttendReport;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.util.List;

/**
 * @author linqinglin
 * @date 2021/08/30 0030 14:14
 */
@Data
public class AttendReportDto extends AttendReport {

    private String name;

    private String departName;

    /** 考勤套ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long attendId;

    /**
     * 刷卡详情
     */
    List<AttendClockDto> clockList;

    /**
     * 请假时长详情
     */
    List<AttendLeave> leaveList;

}
