package com.bcxin.platform.domain.wallet;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 企业钱包交易数据
 *
 * @author llc
 * @date 2019-06-20
 */
@Data
@TableName("com_wallet_reconciliation")
public class ComWalletReconciliation extends BaseEntity<ComWalletReconciliation> {

    /**
     * 交易流水号
     */
    @ApiModelProperty(value = "交易流水号")
    private String tradeSerialNo;

    /**
     * 商户号
     */
    @ApiModelProperty(value = "商户号")
    private String merchantNo;

    /**
     * 交易日期
     */
    @ApiModelProperty(value = "交易日期")
    private String tradeDate;

    /**
     * 请求流水号
     */
    @ApiModelProperty(value = "请求流水号")
    private String requestSerialNo;

    /**
     * 交易金额
     */
    @ApiModelProperty(value = "交易金额")
    private BigDecimal tradeAmount;

    /**
     * 交易状态
     */
    @ApiModelProperty(value = "交易状态")
    private String tradeStatus;

    /**
     * 银行交易类型
     */
    @ApiModelProperty(value = "银行交易类型")
    private String bankTradeType;

    /**
     * 交易订单创建时间
     */
    @ApiModelProperty(value = "交易订单创建时间")
    private String tradeStartTime;

    /**
     * 交易订单完成时间
     */
    @ApiModelProperty(value = "交易订单完成时间")
    private String tradeEndTime;

    /**
     * 出账方账号
     */
    @ApiModelProperty(value = "出账方账号")
    private String expendAccountNo;

    /**
     * 出账方户名
     */
    @ApiModelProperty(value = "出账方户名")
    private String expendAccountName;

    /**
     * 出账方企业ID
     */
    @ApiModelProperty(value = "出账方企业ID")
    private Long expendComId;

    /**
     * 出账方银行编码
     */
    @ApiModelProperty(value = "出账方银行编码")
    private String expendBankCode;

    /**
     * 入账方账号
     */
    @ApiModelProperty(value = "入账方账号")
    private String incomeAccountNo;

    /**
     * 入账方企业ID
     */
    @ApiModelProperty(value = "入账方企业ID")
    private Long incomeComId;

    /**
     * 入账方户名
     */
    @ApiModelProperty(value = "入账方户名")
    private String incomeAccountName;

    /**
     * 入账方银行编码
     */
    @ApiModelProperty(value = "入账方银行编码")
    private String incomedBankCode;

    /**
     * 入账方证件号
     */
    @ApiModelProperty(value = "入账方证件号")
    private String incomeCerNo;

    /**
     * 商户保留域
     */
    @ApiModelProperty(value = "商户保留域")
    private String merchantRetain;

    /**
     * 分账信息
     */
    @ApiModelProperty(value = "分账信息")
    private String allotAccountInfo;

    /**
     * 分润信息
     */
    @ApiModelProperty(value = "分润信息")
    private String allotBenefitInfo;

    /**
     * 交易备注
     */
    @ApiModelProperty(value = "交易备注")
    private String remark;

    /**
     * 手续费
     */
    @ApiModelProperty(value = "手续费")
    private String serviceCharge;

    /**
     * 担保信息
     */
    @ApiModelProperty(value = "担保信息")
    private String guaranteeInfo;

}