package com.bcxin.platform.domain.wallet;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.text.DecimalFormat;

/**
 * 企业钱包账户-收支明细
 *
 * @author lp
 * @date 2019-12-09
 */
@Data
@TableName("com_wallet_account_detail")
public class ComWalletAccountDetail extends BaseEntity<ComWalletAccountDetail> {

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comWalletAccountDetailId;
    private String tradeDate;
    private String tradeFlowNo;
    private String flowNo;
    private String accountsDealType;
    private String accountsDealDate;
    private String amount;
    private String balance;
    private String direction;
    private String handStatus;
    private String createDate;
    private String serviceType;
    private String tradeType;
    private String accountIn;
    private String accountOut;
    private String accountInName;
    private String accountOutName;
    private String memo;
    private String voucherUrl;

    public String getAmount() {
//        return new DecimalFormat("#,##0.00").format(new Double(amount));
        return amount;
    }

//    public String getBalance() {
//        return new DecimalFormat("#,##0.00").format(new Double(balance));
//    }
}