package com.bcxin.platform.domain.system;



import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.util.BaseParam;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.util.List;

/**
 * 公安机构
 *
 * @author llc
 * @date 2019-08-26
 */
@Data
@TableName("sys_police")
public class SysPolice extends BaseParam {

	private static final long serialVersionUID = 1L;

	/**
	 * 公安机构ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long policeId;
    /**
     * 公安机构
     */
	private String policeName;

	/**
	 * 公安级别
	 */
	private String policeLevel;

    /**
     * 上级公安机构ID
     */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long parentPoliceId;

	/**
	 * 排序
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Integer regionId;

    /**
     * 区域ID
     */
	private Integer seq;

	/**
	 * 省份ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Integer provinceId;


	/**
	 * 百保盾ID
	 */
	private Long bbdId;

	/**
	 * 子节点
	 */
	private List<SysPolice> childList;


}
