package com.bcxin.platform.domain.insurance;

import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <b> 企业保险 </b>
 * @author ZXF
 * @create 2021/05/27 0027 16:30
 * @version
 * @注意事项 </b>
 */
@TableName("com_ins")
@Data
@DisMultiTenancy
public class ComIns extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /**
     * 企业保险ID
     */
	private Long comInsId;

    /**
     * 是否逻辑删除
     */
	private String isDelete;
    /**
     * 保险产品名称
     */
	private String productName;
    /**
     * 在保人数
     */
	private Integer perNum;
    /**
     * 购买时间
     */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date buyTime;
    /**
     * 购买方式
     */
	private String buyMode;
    /**
	 * 生效开始日期
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date effectStartDate;
	/**
	 * 生效结束日期
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date effectEndDate;
    /**
     * 保险公司名称
     */
	private String insComName;
    /**
     * 每人保费
     */
	private BigDecimal perPremiums;
    /**
     * 保单号
     */
	private String policyNo;
    /**
     * 保单文件url
     */
	private String policyUrl;
    /**
     * 批单文件url
     */
	private String riderUrl;
    /**
     * 企业ID
     */
	private Long comId;
    /**
     * 项目
     */
	private String tlkProjectId;
    /**
     * 企业保险新增事件ID
     */
	private Long insAddEventId;

	/**
	 * 百联保订单的唯一标识
	 */
	private String blbOrderId;

	/**
	 * 百联保产品代码
	 */
	private String blbProductCode;

	/**
	 * 是否在百联保购买
	 */
	private String isBlbBuy;

	/**
	 * 备注
	 */
	private String remark;

	/**
	 * 授权文件
	 */
	private String authFileUrl;



	@JsonSerialize(using=ToStringSerializer.class)
	public Long getComInsId() {
		return comInsId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getComId() {
		return comId;
	}
	@JsonSerialize(using=ToStringSerializer.class)
	public Long getInsAddEventId() {
		return insAddEventId;
	}
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBuyTime() {
		return buyTime;
	}
	@JsonFormat(pattern = "yyyy-MM-dd")
	public Date getEffectStartDate() {
		return effectStartDate;
	}
	@JsonFormat(pattern = "yyyy-MM-dd")
	public Date getEffectEndDate() {
		return effectEndDate;
	}
}
