package com.bcxin.platform.domain.grant;


import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseParam;
import lombok.Data;

/**
 *
 * 银行网点配置
 *
 *
 * @author llc
 * @date 2020-07-31
 */
@TableName("config_bank_outlets")
@DisMultiTenancy
@Data
public class ConfigBankOutlets extends BaseParam {

    /**
     * 银行网点ID
     */
    private Integer id;

    /**
     * 银行编码
     */
	private String bankCode;

    /**
     * 银行网点
     */
	private String bankOutlets;

    /**
     * 区域
     */
	private String areaName;

    /**
     * 区域代码
     */
	private Integer area;

    /**
     * 银行地址
     */
	private String bankAddress;

	/**
     * 经度
     */
	private String addressLongitude;

    /**
     * 纬度
     */
    private String addressLatitude;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 营业时间
     */
    private String businessHours;



}
