package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 考勤打卡日历套对象 tb_attend_calendar
 * 
 * @author lin
 * @date 2021-08-10
 */
@Data
public class AttendCalendar extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 日历套ID */
    @NotBlank(message="日历套不能为空", groups = {UpdateGroup.class})
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /** 日历套名称 */
    @Excel(name = "日历套名称")
    @NotBlank(message="日历套名称不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String calendarName;

    /** 公司ID */
    @Excel(name = "公司ID")
    @NotNull(message="公司不能为空", groups = {AddGroup.class,UpdateGroup.class})
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;

    /**
     * 部门id
     */
    private Long deptId;
}
