package com.bcxin.obpm.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.bcxin.obpm.mapper.ObpmDepartmentMapper;
import com.bcxin.obpm.domain.ObpmDepartment;
import com.bcxin.obpm.service.ObpmDepartmentService;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;


/**
 * V5部门Service业务层处理
 * 
 * @author lin
 * @date 2021-06-06
 */
@Service
public class ObpmDepartmentServiceImpl implements ObpmDepartmentService{

    @Resource
    private ObpmDepartmentMapper obpmDepartmentMapper;

    /**
     * 查询V5部门
     * 
     * @param ID V5部门ID
     * @return V5部门
     */
    @Override
    public ObpmDepartment selectObpmDepartmentById(String ID){
        return obpmDepartmentMapper.selectObpmDepartmentById(ID);
    }

    /**
     * 查询V5部门列表
     * 
     * @param tlkComId V5公司id
     * @return V5部门
     */
    @Override
    public List<ObpmDepartment> selectObpmDepartmentList(String tlkComId){
        return obpmDepartmentMapper.selectObpmDepartmentList(tlkComId);
    }

}
