package com.bcxin.obpm.mapper;

import com.bcxin.obpm.domain.UserDepartment;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * v5人员部门Mapper接口
 * 
 * @author lin
 * @date 2021-06-06
 */
public interface UserDepartmentMapper{

    /**
     * 查询v5人员部门
     * 
     * @param id v5人员部门ID
     * @return v5人员部门
     */
    UserDepartment selectUserDepartmentById(String id);

    List<UserDepartment> selectUserDepartmentByUserId(String userId);

    /**
     * 查询v5人员部门列表
     * 
     * @param tlkIds v5人员Id集合
     * @return v5人员部门集合
     */
    List<UserDepartment> selectUserDepartmentList(@Param("list")List<String> tlkIds);

}
