package com.bcxin.platform.service.attend.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.bcxin.oaflow.mapper.MakeUpCardMapper;
import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.constant.DictConst;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.exception.PlatFormBusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.common.utils.validator.ValidatorUtils;
import com.bcxin.platform.common.utils.validator.group.OneGroup;
import com.bcxin.platform.common.utils.validator.group.TwoGroup;
import com.bcxin.platform.domain.attend.*;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.dto.app.*;
import com.bcxin.platform.dto.attend.AttendDto;
import com.bcxin.platform.mapper.attend.*;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.mapper.company.PerOrgRelationMapper;
import com.bcxin.platform.service.attend.AttendService;
import com.bcxin.platform.service.attend.AttendShiftService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 考勤套Service业务层处理
 * 
 * @author lin
 * @date 2021-08-10
 */
@Service
@Transactional("transactionManager")
public class AttendServiceImpl implements AttendService{

    @Autowired
    private AttendShiftService attendShiftService;

    @Autowired
    private AttendMapper attendMapper;

    @Autowired
    private AttendShiftMapper attendShiftMapper;

    @Autowired
    private AttendChargeMapper attendChargeMapper;

    @Autowired
    private AttendClockMapper attendClockMapper;

    @Autowired
    private MakeUpCardMapper makeUpCardMapper;

    @Autowired
    private PerBaseInfoMapper perBaseInfoMapper;

    @Autowired
    private PerOrgRelationMapper perOrgRelationMapper;

    @Autowired
    private AttendPerMapper attendPerMapper;

    @Autowired
    private AttendAddressMapper attendAddressMapper;

    @Autowired
    private AttendWifiMapper attendWifiMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询考勤套
     * 
     * @param id 考勤套ID
     * @return 考勤套
     */
    @Override
    public Attend findById(Long id){
        Attend attend =  attendMapper.findById(id);
        if(attend != null){
            List<PerBaseInfo> chargeList = attendChargeMapper.findPerByAttendId(id);
            attend.setChargeList(chargeList);
            List<Long> chargeIds = chargeList.stream().map(PerBaseInfo::getPerId).collect(Collectors.toList());
            List<String> charges = chargeIds.stream().map(s -> s.toString()).collect(Collectors.toList());
            attend.setChargeIds(charges.toArray(new String[0]));

            attend.setAddressList(attendAddressMapper.findByAttendId(id));
            attend.setWifiList(attendWifiMapper.findByAttendId(id));

            List<AttendPer> perList = attendPerMapper.findByAttendId(id);
            attend.setPerNum(perList.size());
        }
        return attend;
    }

    /**
     * 查询用户考勤套
     *
     * @param searchDto
     * @return 考勤套
     */
    @Override
    public AppAttendDto findByPerId(AppAttendSearchDto searchDto){
        Attend attend = attendMapper.findByPerId(searchDto.getPerId());
        if(attend == null){
            return null;
        }
        AppAttendDto appAttend = new AppAttendDto();
        BeanUtils.copyPropertiesIgnore(attend,appAttend,false);

        List<AppAttendSchedulClockDto> schedulClockList = attendClockMapper.selectListForApp(searchDto);
        Integer clockCount = 0;
        Integer missCount = 0;
        if(DictConst.SHIFTTYPE_JCBC.equals(attend.getShiftType())) {
            appAttend.setTotal(schedulClockList.size());
        }else {
            appAttend.setTotal(schedulClockList.size() * 2);
        }
        if(schedulClockList.size() > 0) {
            appAttend.setSchedulClockList(schedulClockList);
            for (AppAttendSchedulClockDto schedulClockDto : schedulClockList) {
                if(StrUtil.isNotEmpty(schedulClockDto.getClockStart())){
                    clockCount++;
                }
                if(StrUtil.isNotEmpty(schedulClockDto.getClockEnd())){
                    clockCount++;
                }
                if(DictConst.CLOCKSTATUS_21.equals(schedulClockDto.getClockStatus())
                    || DictConst.CLOCKSTATUS_22.equals(schedulClockDto.getClockStatus())
                    || DictConst.CLOCKSTATUS_23.equals(schedulClockDto.getClockStatus())
                    || DictConst.CLOCKSTATUS_24.equals(schedulClockDto.getClockStatus())){
                    missCount++;
                }else if(DictConst.CLOCKSTATUS_3.equals(schedulClockDto.getClockStatus())){
                    if(DictConst.SHIFTTYPE_JCBC.equals(schedulClockDto.getShiftType())) {
                        continue;
                    }
                    if(StrUtil.isEmpty(schedulClockDto.getClockEnd())){
                        if(DateUtils.parseDate(schedulClockDto.getEndTime()).getTime()<DateUtils.addMinutes(DateUtils.getNowDate(),-30).getTime()){
                            //下班缺卡
                            schedulClockDto.setClockStatus(DictConst.CLOCKSTATUS_23);
                        }
                    }
                }else if(DictConst.CLOCKSTATUS_5.equals(schedulClockDto.getClockStatus())){
                    if(DictConst.SHIFTTYPE_JSBC.equals(schedulClockDto.getShiftType())) {
                        missCount = missCount + 2;
                    }else{
                        missCount = missCount + 1;
                    }
                }else if(StrUtil.isEmpty(schedulClockDto.getClockStatus())){
                    if(DictConst.SHIFTTYPE_JCBC.equals(schedulClockDto.getShiftType())) {
                        continue;
                    }
                    if(DateUtils.parseDate(schedulClockDto.getEndTime()).getTime()<DateUtils.getNowDate().getTime()){
                        //过了下班时间
                        if(StrUtil.isEmpty(schedulClockDto.getClockStart())){
                            //缺勤
                            if(DateUtils.parseDate(schedulClockDto.getEndTime()).getTime()<DateUtils.addMinutes(DateUtils.getNowDate(),-30).getTime()) {
                                schedulClockDto.setClockStatus(DictConst.CLOCKSTATUS_5);
                                missCount = missCount + 2;
                            }else{
                                schedulClockDto.setClockStatus(DictConst.CLOCKSTATUS_21);
                                missCount++;
                            }
                        }else{
                            //下班缺卡
                            if(DateUtils.parseDate(schedulClockDto.getEndTime()).getTime()<DateUtils.addMinutes(DateUtils.getNowDate(),-30).getTime()) {
                                schedulClockDto.setClockStatus(DictConst.CLOCKSTATUS_22);
                                missCount++;
                            }
                        }
                    }else{
                        //if(StrUtil.isEmpty(schedulClockDto.getClockStart())){
                        //    if(DateUtils.parseDate(schedulClockDto.getStartTime()).getTime()<DateUtils.getNowDate().getTime()) {
                        //        //未到下班时间，则算上班迟到
                        //        schedulClockDto.setClockStatus(DictConst.CLOCKSTATUS_3);
                        //    }
                        //}
                    }
                }
            }
        }
        appAttend.setClockCount(clockCount);
        appAttend.setMissCount(missCount);

        appAttend.setAddressList(attendAddressMapper.findByAttendId(appAttend.getId()));
        appAttend.setWifiList(attendWifiMapper.findByAttendId(appAttend.getId()));
        return appAttend;
    }

    @Override
    public Integer getCountLimit(AppAttendSearchDto searchDto) {
        Attend attend = attendMapper.findByPerId(searchDto.getPerId());
        if(attend == null){
            return 0;
        }
        //TODO 计算已申请补卡次数
        PerBaseInfo perBaseInfo = perBaseInfoMapper.selectPerBaseInfoById(searchDto.getPerId());
        Map<String,Object> paramMap = new HashMap<>();
        //上个月到这个月的
        paramMap.put("beginTime", DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD, DateUtil.beginOfMonth(DateUtils.addMonths(DateUtils.getNowDate(),-1)).toJdkDate()));
        paramMap.put("endTime",DateUtils.getDate());
        paramMap.put("tlkPerId",perBaseInfo.getTlkPerId());
        Integer count = makeUpCardMapper.getCount(perBaseInfo.getTlkPerId(),searchDto.getSchedulDate());

        return attend.getCountLimit() != null ? attend.getCountLimit()-count: null;
    }

    /**
     * 查询考勤套列表
     * 
     * @param searchDto 考勤套
     * @return 考勤套
     */
    @Override
    public List<Attend> selectList(AttendDto searchDto){
        //加上数据权限
        if(!searchDto.isDomainAdmin() && (searchDto.getAdminDepartIds()== null || searchDto.getAdminDepartIds().size() == 0)){
            return new ArrayList<>();
        }
        return attendMapper.selectList(searchDto);
    }
    /**
     * 查询考勤套列表
     *
     * @param attend 考勤套
     * @return 考勤套
     */
    @Override
    public List<Attend> selectListForPer(AttendDto attend){
        return attendMapper.selectListForPer(attend);
    }

    @Override
    public List<Attend> selectListForChargePer(AttendDto attend){
        return attendMapper.selectListForChargePer(attend);
    }

    @Override
    public List<AppAttendManageDto> selectManageListForChargePer(AttendDto attend) {
        return attendMapper.selectManageListForChargePer(attend);
    }

    @Override
    public int updateForApp(AppAttendEditDto attend) {
        int count = this.update(attend);
        if(attend.getPerIds() != null && attend.getPerIds().length > 0) {
            AttendPer attendPer = null;
            List<AttendPer> perList = new ArrayList<>();
            for (String perId : attend.getPerIds()) {
                attendPer = new AttendPer();
                attendPer.setAttendId(attend.getId());
                attendPer.setComId(attend.getComId());
                attendPer.setId(idWorker.nextId());
                attendPer.setPerId(Long.parseLong(perId));
                attendPer.setCreateTime(DateUtils.getNowDate());
                attendPer.setCreateBy(attend.getCreateBy());
                attendPer.setIsDelete(Constants.N);
                attendPer.setUpdateBy(attend.getUpdateBy());
                attendPer.setUpdateTime(DateUtils.getNowDate());
                perList.add(attendPer);
            }
            attendPerMapper.saveBatch(perList);
        }
        if(attend.getShiftList() != null && attend.getShiftList().size() > 0) {
            Long deptId = null;
            if (StrUtil.isNotEmpty(attend.getCreateBy())) {
                PerOrgRelation perOrgRelation = perOrgRelationMapper.findByPerId(Long.parseLong(attend.getCreateBy()));
                deptId = perOrgRelation.getOrgId();
            }

            for (AttendShift attendShift : attend.getShiftList()) {
                attendShift.setAttendId(attend.getId());
                attendShift.setShiftType(attend.getShiftType());
                attendShiftService.validateData(attendShift);
                attendShift.setCreateTime(DateUtils.getNowDate());
                attendShift.setUpdateTime(DateUtils.getNowDate());
                attendShift.setCreateBy(attend.getCreateBy());
                attendShift.setUpdateBy(attend.getUpdateBy());
                attendShift.setId(idWorker.nextId());
                attendShift.setIsDelete(Constants.N);
                attendShift.setDeptId(deptId);

                if (DictConst.SHIFTTYPE_JCBC.equals(attend.getShiftType())) {
                    attendShift.setShiftHour(null);
                    attendShift.setEndTime(null);
                    attendShift.setNeedRest(Constants.N);
                }

                if (Constants.N.equals(attendShift.getNeedRest())) {
                    attendShift.setRestStart(null);
                    attendShift.setRestEnd(null);
                    attendShift.setRestHour(0.0D);
                }
            }
            attendShiftMapper.saveBatch(attend.getShiftList());
        }

        if(attend.getAddressList() != null && DictConst.CLOCKTYPE_POSITION.equals(attend.getClockType())){
            for (AttendAddress attendAddress : attend.getAddressList()) {
                attendAddress.setIsDelete(Constants.N);
                if(attendAddress.getId() == null) {
                    attendAddress.setId(idWorker.nextId());
                    attendAddress.setCreateBy(attend.getCreateBy());
                    attendAddress.setCreateTime(attend.getCreateTime());
                }
                attendAddress.setUpdateBy(attend.getCreateBy());
                attendAddress.setUpdateTime(attend.getCreateTime());
                attendAddress.setAttendId(attend.getId());
            }
            attendAddressMapper.saveBatch(attend.getAddressList());
        }

        if(attend.getWifiList() != null && DictConst.CLOCKTYPE_WIFI.equals(attend.getClockType())){
            for (AttendWifi attendWifi : attend.getWifiList()) {
                attendWifi.setIsDelete(Constants.N);
                if(attendWifi.getId() == null) {
                    attendWifi.setId(idWorker.nextId());
                    attendWifi.setCreateBy(attend.getCreateBy());
                    attendWifi.setCreateTime(attend.getCreateTime());
                }
                attendWifi.setUpdateBy(attend.getCreateBy());
                attendWifi.setUpdateTime(attend.getCreateTime());
                attendWifi.setAttendId(attend.getId());
            }
            attendWifiMapper.saveBatch(attend.getWifiList());
        }

        return count;
    }

    /**
     * 修改考勤套
     * 
     * @param attend 考勤套
     * @return 结果
     */
    @Override
    public int update(Attend attend){

        Attend dbAttend = attendMapper.findbyName(attend.getAttendName());
        if(dbAttend != null && !dbAttend.getId().equals(attend.getId())){
            throw new BusinessException("【" + attend.getAttendName() + "】该考勤套名称已存在，不能重复！");
        }

        if(attend.getId() == null){
            attend.setCreateTime(DateUtils.getNowDate());
            attend.setId(idWorker.nextId());
            attend.setIsDelete(Constants.N);
            if(StrUtil.isEmpty(attend.getActive())){
                attend.setActive(Constants.N);
            }

//            PerOrgRelation relation = perOrgRelationMapper.findByPerId(Long.parseLong(attend.getCreateBy()));
//            attend.setDeptId(relation.getOrgId());
        }else{
            // 判断班次是否在使用中，如果在使用中，则不能修改。
            List<Attend> attends = attendMapper.findUsedList(Convert.toStrArray(attend.getId().toString()));
            for (Attend existAttend : attends) {
                throw new BusinessException("【" + attend.getAttendName() + "】该考勤套在使用中，不能修改！");
            }

            dbAttend = attendMapper.findById(attend.getId());

            BeanUtils.copyPropertiesIgnore(attend,dbAttend,true);
            BeanUtils.copyPropertiesIgnore(dbAttend,attend,false);
        }
        attend.setUpdateTime(DateUtils.getNowDate());

        if(attend.getChargeIds() != null && attend.getChargeIds().length > 0){
            List<AttendCharge> chargeList = attendChargeMapper.findByAttendId(attend.getId());
            Map<Long, AttendCharge> chargeMap =chargeList.stream().collect(Collectors.toMap(AttendCharge::getPerId, Function.identity()));
            Map<String,String> chargeIdMap = Arrays.stream(attend.getChargeIds()).collect(Collectors.toMap(String::toString, Function.identity()));

            List<AttendCharge> saveList = new ArrayList<>();
            AttendCharge saveCharge = null;

            for (String chargeId : attend.getChargeIds()) {
                if (chargeMap.get(Long.parseLong(chargeId)) == null) {
                    saveCharge = new AttendCharge();
                    saveCharge.setIsDelete(Constants.N);
                    saveCharge.setAttendId(attend.getId());
                    saveCharge.setPerId(Long.parseLong(chargeId));
                    saveCharge.setCreateTime(DateUtils.getNowDate());
                    saveCharge.setCreateBy(attend.getUpdateBy());
                    saveCharge.setUpdateTime(DateUtils.getNowDate());
                    saveCharge.setUpdateBy(attend.getUpdateBy());
                    saveList.add(saveCharge);
                }
            }
            for (AttendCharge attendCharge : chargeList) {
                if (chargeIdMap.get(attendCharge.getPerId().toString()) == null) {
                    attendCharge.setIsDelete(Constants.Y);
                    attendCharge.setUpdateBy(attend.getUpdateBy());
                    attendCharge.setUpdateTime(DateUtils.getNowDate());
                    saveList.add(attendCharge);
                }
            }

            if(saveList.size() > 0){
                attendChargeMapper.saveBatch(saveList);
            }
        }

        return attendMapper.save(attend);
    }

    /**
     * 删除考勤套对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids){

        List<Attend> attends = attendMapper.findByArrIds(Convert.toStrArray(ids));
        for (Attend attend : attends) {
            if(Constants.Y.equals(attend.getActive())){
                throw new BusinessException("【" + attend.getAttendName() + "】该考勤套启用中，不能删除！");
            }
        }
        // 判断班次是否在使用中，如果在使用中，则不能删除。
        attends = attendMapper.findUsedList(Convert.toStrArray(ids));
        for (Attend attend : attends) {
            throw new BusinessException("【" + attend.getAttendName() + "】该考勤套在使用中，不能删除！");
        }

        return attendMapper.deleteByIds(Convert.toStrArray(ids));
    }

}
