package com.bcxin.platform.mapper.grant;


import com.bcxin.platform.domain.grant.PerJointlyCard;
import com.bcxin.platform.dto.grant.PerJointlyCardDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 个人联名卡服务
 * @author llc
 * @date 2020-07-21
 */
public interface PerJointlyCardMapper{


    /**
     * 批量更新保安员联名卡
     * @param list
     * @author llc
     * @date 2020-07-22
     * @return
     */
    Integer batchUpdatePerJointlyCard(@Param("list") List<PerJointlyCard> list);

    /**
     * 获取企业已开通联名卡人数
     * @param comId
     * @author llc
     * @date 2020-07-21
     * @return
     */
    Integer getOpenJointlyPerCount(@Param("comId") Long comId);

    /**
     * 获取企业未开通联名卡人员列表
     * @param dto
     * @author llc
     * @date 2020-07-21
     */
    List<Map<String,String>> getNoOpenJointlyPerList(PerJointlyCardDTO dto);

    /**
     * 获取企业已开通联名卡人员列表
     * @param dto
     * @author llc
     * @date 2020-07-21
     */
    List<Map<String,String>> getOpenJointlyPerList(PerJointlyCardDTO dto);


    /**
     * 获取企业未开联名卡人员ID列表
     * @author llc
     * @date 2020-07-21
     * @return
     */
    List<String> getNoOpenJointlyPerIdList(@Param("comId") Long comId);

    /**
     * 获取保安员联名卡信息
     * @author llc
     * @date 2020-07-29
     * @return
     */
    PerJointlyCard getPerJointlyCard(@Param("perId") Long perId);
}