package com.bcxin.platform.service.grant;


import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.grant.ComGrantRecord;

/**
 * 企业发放记录
 * @author llc
 * @date 2020-03-27
 */
public interface ComGrantRecordService {

    /**
     * 获取企业发放记录列表
     * @param comGrantRecord
     * @author llc
     * @date 2020-03-27
     */
    Result pageComGrantRecordList(ComGrantRecord comGrantRecord) throws V5BusinessException;


    /**
     * 保存企业线下发放记录
     * @param comGrantRecord
     * @author llc
     * @date 2020-03-27
     */
    Result saveOffLineGrantRecord(ComGrantRecord comGrantRecord) throws V5BusinessException;


    /**
     * 删除企业线下发放记录
     * @param comGrantRecord
     * @author llc
     * @date 2020-03-27
     */
    Result deleteOffLineGrantRecord(ComGrantRecord comGrantRecord) throws V5BusinessException;

}