package com.bcxin.platform.service.attend.impl;

import java.util.List;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.bcxin.platform.mapper.attend.AttendAddressMapper;
import com.bcxin.platform.domain.attend.AttendAddress;
import com.bcxin.platform.service.attend.AttendAddressService;
import com.bcxin.platform.common.core.text.Convert;
import javax.annotation.Resource;

/**
 * 考勤地点定位Service业务层处理
 * 
 * @author lin
 * @date 2022-04-09
 */
@Service
@Transactional
public class AttendAddressServiceImpl implements AttendAddressService{

    @Autowired
    private AttendAddressMapper attendAddressMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询考勤地点定位
     * 
     * @param id 考勤地点定位ID
     * @return 考勤地点定位
     */
    @Override
    public AttendAddress findById(Long id){
        return attendAddressMapper.findById(id);
    }

    /**
     * 查询考勤地点定位列表
     * 
     * @param attendAddress 考勤地点定位
     * @return 考勤地点定位
     */
    @Override
    public List<AttendAddress> selectList(AttendAddress attendAddress){
        return attendAddressMapper.selectList(attendAddress);
    }

    /**
     * 修改考勤地点定位
     * 
     * @param attendAddress 考勤地点定位
     * @return 结果
     */
    @Override
    public int update(AttendAddress attendAddress){
        if(attendAddress.getId() == null){
            attendAddress.setCreateTime(DateUtils.getNowDate());
            attendAddress.setId(idWorker.nextId());
        }else{
            AttendAddress dbAttendAddress = attendAddressMapper.findById(attendAddress.getId());
            BeanUtils.copyPropertiesIgnore(attendAddress,dbAttendAddress,true);
            BeanUtils.copyPropertiesIgnore(dbAttendAddress,attendAddress,false);
        }
        attendAddress.setUpdateTime(DateUtils.getNowDate());
        return attendAddressMapper.save(attendAddress);
    }

    /**
     * 删除考勤地点定位对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids){
        return attendAddressMapper.deleteByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除考勤地点定位信息
     * 
     * @param id 考勤地点定位ID
     * @return 结果
     */
    @Override
    public int deleteById(Long id){
        return attendAddressMapper.deleteById(id);
    }
}
