package com.bcxin.platform.mapper.wallet;

import com.bcxin.platform.domain.wallet.ComWalletReconciliation;
import com.bcxin.platform.dto.wallet.ComWalletTradeDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 企业钱包对账数据
 *
 * @author llc
 * @date 2019-09-17
 */
public interface ComWalletReconciliationMapper {


    /**
     * 插入临时企业钱包对账数据
     *
     * @param list
     * @return
     * @author llc
     * @date 2019-09-17
     */
    int insertTempReconciliationList(@Param("list") List<ComWalletReconciliation> list);


    /**
     * 插入企业钱包对账数据
     *
     * @return
     * @author llc
     * @date 2019-09-18
     */
    int insertComWalletReconciliation(@Param("tradeDate") String tradeDate);


    /**
     * 更新企业钱包对账数据
     *
     * @return
     * @author llc
     * @date 2019-09-18
     */
    int updateComWalletReconciliation(@Param("tradeDate") String tradeDate);


    /**
     * 清除临时企业钱包对账数据
     *
     * @return
     * @author llc
     * @date 2019-09-18
     */
    int deleteTempWalletReconciliation();


    /**
     * 企业钱包账户对账数据生成
     *
     * @author llc
     * @date 2019-09-19
     */
    List<Map<String, Object>> getWalletReconciliationList(ComWalletTradeDTO dto);


    /**
     * 获取企业钱包账户对账统计数据
     *
     * @author llc
     * @date 2019-09-19
     */
    Map<String, Object> getWalletReconciliationSum(ComWalletTradeDTO dto);

}