package com.bcxin.platform.mapper.meeting;

import com.bcxin.platform.domain.meeting.PerHuaweiMeetMatch;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人员华为云会议映射
 * @author llc
 * @date 2019-12-10
 */
@Mapper
public interface PerHuaweiMeetMatchMapper {

    /**
     * 获取人员华为云会议映射详情
     *
     * @param perId
     * @return
     * @author llc
     * @date 2019-12-10
     */
    PerHuaweiMeetMatch getPerHuaweiMeetMatchByPerId(@Param("perId") Long perId);


    /**
     * 插入人员华为云会议映射
     * @param perHuaweiMeetMatch
     * @author llc
     * @date 2019-12-10
     * @return
     */
    Integer insertPerHuaweiMeetMatch(PerHuaweiMeetMatch perHuaweiMeetMatch);


    /**
     * 更新人员华为云会议映射
     * @param perHuaweiMeetMatch
     * @author llc
     * @date 2020-12-03
     * @return
     */
    Integer updatePerHuaweiMeetMatch(PerHuaweiMeetMatch perHuaweiMeetMatch);

    /**
     * 获取人员华为云会议映射列表
     * @param perIdList
     * @author llc
     * @date 2019-12-12
     * @return
     */
    List<PerHuaweiMeetMatch> getPerHuaweiMeetMatchByPerIdList(@Param("list") List<String> perIdList);

    /**
     * 批量删除人员华为云会议映射
     * @param perIdList
     * @author llc
     * @date 2019-12-12
     * @return
     */
    Integer batchDeletePerHuaweiMeetMatch(@Param("list") List<Long> perIdList);

}