package com.bcxin.platform.domain.order;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 企业订单详情
 * 
 * @author llc
 * @date 2020-01-15
 */
@Data
@TableName("com_order_detail")
public class ComOrderDetail extends BaseEntity<ComOrderDetail> {

	/** 企业订单详情ID */
	@ApiModelProperty(value = "企业订单详情ID")
	private Long comOrderDetailId;

	/** 产品购买方式ID */
	@ApiModelProperty(value = "产品购买方式ID")
	private String productBuyModeId;

	/** 产品名称 */
	@ApiModelProperty(value = "产品名称")
	private String productName;

	/** 单价 */
	@ApiModelProperty(value = "单价")
	private BigDecimal eachAmount;

	/** 单位 */
	@ApiModelProperty(value = "单位")
	private String unit;

	/** 数量 */
	@ApiModelProperty(value = "数量")
	private Integer num;

	/** 时长 */
	@ApiModelProperty(value = "时长")
	private Integer duration;

	/** 订单金额 */
	@ApiModelProperty(value = "订单金额")
	private BigDecimal amount;

	/** 企业订单ID */
	@ApiModelProperty(value = "企业订单ID")
	private Long comOrderId;

	/** '到期时间 */
	@ApiModelProperty(value = "'到期时间")
	private Date expireTime;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComOrderId() {
		return comOrderId;
	}

}