package com.bcxin.platform.domain.grant;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 企业渤海发放信息
 * 
 * @author llc
 * @date 2020-08-13
 */
@Data
@TableName("com_bh_grant_info")
public class ComBhGrantInfo extends BaseEntity<ComBhGrantInfo> {

	/** 企业渤海发放ID */
	@ApiModelProperty(value = "企业渤海发放ID")
	private Long comBhGrantId;

	/** 发放年月 */
	@ApiModelProperty(value = "发放年月")
	private String grantYears;

	/** 发放类型 */
	@ApiModelProperty(value = "发放类型")
	private String grantType;

	/** 提交状态 */
	@ApiModelProperty(value = "提交状态")
	private String commitStatus;

	/** 发放总额 */
	@ApiModelProperty(value = "发放总额")
	private BigDecimal sumAmount;

	/** 发放总笔数 */
	@ApiModelProperty(value = "发放总笔数")
	private Integer grantCount;

	/** 实际发放总额 */
	@ApiModelProperty(value = "实际发放总额")
	private BigDecimal totalSumAmount;

	/** 实际发放笔数 */
	@ApiModelProperty(value = "实际发放笔数")
	private Integer totalGrantCount;

	/** 失败发放总额 */
	@ApiModelProperty(value = "失败发放总额")
	private BigDecimal failSumAmount;

	/** 失败发放笔数 */
	@ApiModelProperty(value = "失败发放笔数")
	private Integer failGrantCount;

	/** 发放数据来源 */
	@ApiModelProperty(value = "发放数据来源")
	private String grantDataSource;

	/** 标题 */
	@ApiModelProperty(value = "标题")
	private String title;

	/** 备注 */
	@ApiModelProperty(value = "备注")
	private String remark;

	/** 代发单文件名 */
	@ApiModelProperty(value = "代发单文件名")
	private String fileName;

	/** 是否同步银行结果 */
	@ApiModelProperty(value = "是否同步银行结果")
	private String isSyncBankResult;

	/** 银行回执文件URL */
	@ApiModelProperty(value = "银行回执文件URL")
	private String bankReceiptFileUrl;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComBhGrantId() {
		return comBhGrantId;
	}

}