/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.wallet;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.wallet.ComWalletChangeDetail;
import com.bcxin.platform.domain.wallet.ComWalletChangeEvent;
import com.bcxin.platform.dto.wallet.ComWalletAccountDTO;
import com.bcxin.platform.dto.wallet.ComWalletChangeDTO;
import com.bcxin.platform.mapper.wallet.ComWalletAccountMapper;
import com.bcxin.platform.mapper.wallet.ComWalletChangeMapper;
import com.bcxin.platform.service.wallet.ComWalletChangeService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class ComWalletChangeServiceImpl
implements ComWalletChangeService {
    @Resource
    private ComWalletAccountMapper comWalletAccountMapper;
    @Resource
    private ComWalletChangeMapper comWalletChangeMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public Result saveBankCardChangeEvent(ComWalletChangeDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getBankCardNo())) {
            throw new V5BusinessException("-1", "\u65b0\u7ed1\u5b9a\u5361\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getBankCode())) {
            throw new V5BusinessException("-1", "\u65b0\u7ed1\u5b9a\u5361\u94f6\u884c\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getBankName())) {
            throw new V5BusinessException("-1", "\u65b0\u7ed1\u5b9a\u5361\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getBankCardUrl())) {
            throw new V5BusinessException("-1", "\u65e7\u7ed1\u5b9a\u5361\u5f00\u6237\u8bb8\u53ef\u8bc1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getChangeProveUrl())) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u94b1\u5305\u4fe1\u606f\u4fee\u6539\u8bc1\u660e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.comWalletChangeMapper.isUnApproveEvent(dto.getComId()) > 0) {
            throw new V5BusinessException("-1", "\u5df2\u6709\u5ba1\u6279\u4e2d\u7684\u4fee\u6539\u94f6\u884c\u5361\u8bb0\u5f55\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6838");
        }
        ComWalletAccountDTO accountDto = this.comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        if (dto.getBankCode().equals(accountDto.getBankCode()) && dto.getBankCardNo().equals(accountDto.getBankCardNo())) {
            throw new V5BusinessException("-1", "\u53d8\u66f4\u4fe1\u606f\u4e0d\u80fd\u4e0e\u5386\u53f2\u4fe1\u606f\u4e00\u81f4");
        }
        Long eventId = this.idWorker.nextId();
        ComWalletChangeEvent event = new ComWalletChangeEvent();
        event.setComWalletChangeEventId(eventId);
        event.setComName(accountDto.getComName());
        event.setComId(dto.getComId());
        event.setChangeProveUrl(dto.getChangeProveUrl());
        event.setComWalletChangeType("1");
        event.setBankCardUrl(dto.getBankCardUrl());
        event.setWalletAccountNo(accountDto.getWalletAccountNo());
        event.setApproveStatus("0");
        event.setCreateTime(new Date());
        event.setCreateBy(dto.getCreateBy());
        String[] fields = new String[]{"bankCode", "bankCardNo"};
        ArrayList list = Lists.newArrayList();
        for (String f : fields) {
            ComWalletChangeDetail detail = new ComWalletChangeDetail();
            detail.setComWalletChangeDetailId(this.idWorker.nextId());
            detail.setComWalletChangeEventId(eventId);
            detail.setCreateBy(dto.getCreateBy());
            if ("bankCode".equals(f)) {
                if (dto.getBankCode().equals(accountDto.getBankCode())) continue;
                detail.setChangeBeforeInfo(accountDto.getBankCode());
                detail.setChangeBeforeShowInfo(accountDto.getBankName());
                detail.setChangeAfterInfo(dto.getBankCode());
                detail.setChangeAfterShowInfo(dto.getBankName());
                detail.setChangeCode("bankCode");
                detail.setChangeCodeCn("\u94f6\u884c\u7f16\u7801");
            } else {
                if (dto.getBankCardNo().equals(accountDto.getBankCardNo())) continue;
                detail.setChangeBeforeInfo(accountDto.getBankCardNo());
                detail.setChangeBeforeShowInfo(accountDto.getBankCardNo());
                detail.setChangeAfterInfo(dto.getBankCardNo());
                detail.setChangeAfterShowInfo(dto.getBankCardNo());
                detail.setChangeCode("bankCardNo");
                detail.setChangeCodeCn("\u94f6\u884c\u5361\u53f7");
            }
            detail.setChangeCodeTable("com_wallet_account");
            detail.setTableType("2");
            list.add(detail);
        }
        if (list.size() == 0) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u94b1\u5305\u53d8\u66f4\u4fe1\u606f\u6536\u96c6\u5f02\u5e38");
        }
        this.comWalletChangeMapper.insertComWalletChangeEvent(event);
        this.comWalletChangeMapper.batchSetComWalletChangeDetail(list);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

