/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.config;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.spring.SpringUtils;
import com.bcxin.platform.dto.oauth.AccessToken;
import com.bcxin.platform.service.oauth.OAuthService;
import com.bcxin.platform.util.http.ParameterRequestWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V5AccessControlFilter
implements Filter {
    protected final Logger logger = LoggerFactory.getLogger(V5AccessControlFilter.class);

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        this.logger.error("request url:" + request.getRequestURL().toString());
        this.logger.error("request Params:" + JSONObject.toJSONString((Object)request.getParameterMap()));
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "*");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Headers", "x-requested-with,content-type,Content-type,authorization,x-csrf-token,access_token,userV5Token");
        response.setHeader("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
        String access_token = request.getHeader("access_token");
        String userV5TokenStr = request.getHeader("userV5Token");
        boolean userV5Token = false;
        if ("1".equals(userV5TokenStr)) {
            userV5Token = true;
        }
        this.logger.error("request access_token:" + access_token);
        this.logger.error("request userV5Token:" + userV5Token);
        if (StringUtils.isNotEmpty((String)access_token)) {
            OAuthService oAuthService = (OAuthService)SpringUtils.getBean(OAuthService.class);
            if (oAuthService != null) {
                AccessToken accessToken = oAuthService.getAccessToken(access_token, userV5Token);
                if (accessToken != null) {
                    request.setAttribute("createBy", (Object)accessToken.getPerId());
                    request.setAttribute("updateBy", (Object)accessToken.getPerId());
                    request.setAttribute("comId", (Object)accessToken.getComId());
                    request.setAttribute("perId", (Object)accessToken.getPerId());
                    request.setAttribute("createName", (Object)accessToken.getName());
                    request.setAttribute("updateName", (Object)accessToken.getName());
                    request.setAttribute("domainAdmin", (Object)accessToken.isDomainAdmin());
                    request.setAttribute("adminOrgIds", (Object)accessToken.getAdminOrgIds());
                    HashMap<String, Object> paramter = new HashMap<String, Object>();
                    if (StrUtil.isEmpty((CharSequence)request.getParameter("comId"))) {
                        paramter.put("comId", accessToken.getComId());
                    }
                    paramter.put("createBy", accessToken.getPerId());
                    paramter.put("updateBy", accessToken.getPerId());
                    paramter.put("createName", accessToken.getName());
                    paramter.put("updateName", accessToken.getName());
                    paramter.put("domainAdmin", accessToken.isDomainAdmin());
                    paramter.put("adminOrgIds", accessToken.getAdminOrgIds());
                    ParameterRequestWrapper wrapper = new ParameterRequestWrapper(request, paramter);
                    filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
                    return;
                }
                Result result = Result.tokenExpired((String)"\u7528\u6237\u767b\u9646\u8d85\u65f6\u6216\u8005\u672a\u767b\u9646").setBack(request);
                ObjectMapper mapper = new ObjectMapper();
                PrintWriter out = response.getWriter();
                out.print(mapper.writeValueAsString((Object)result));
                out.close();
                return;
            }
        } else {
            Result result = Result.tokenExpired((String)"access_token\u7f3a\u5931").setBack(request);
            ObjectMapper mapper = new ObjectMapper();
            PrintWriter out = response.getWriter();
            out.print(mapper.writeValueAsString((Object)result));
            out.close();
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

