/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.utilities;

import cn.wildfirechat.sdk.model.IMResult;
import cn.wildfirechat.sdk.utilities.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelHttpUtils
extends JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelHttpUtils.class);
    public static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private String imurl;
    private String channelId;
    private String channelSecret;
    private final CloseableHttpClient httpClient;

    public ChannelHttpUtils(String imurl, String channelId, String secret) {
        this.imurl = imurl.trim();
        this.channelId = channelId.trim();
        this.channelSecret = secret.trim();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setValidateAfterInactivity(1000);
        int connectTimeout = 5000;
        int socketTimeout = 15000;
        int connectionRequestTimeout = 3000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
        this.httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)cm).evictExpiredConnections().evictIdleConnections(60L, TimeUnit.SECONDS).setRetryHandler((HttpRequestRetryHandler)DefaultHttpRequestRetryHandler.INSTANCE).setMaxConnTotal(100).setMaxConnPerRoute(50).build();
    }

    public <T> IMResult<T> httpJsonPost(String path, Object object, Class<T> clazz) throws Exception {
        if (ChannelHttpUtils.isNullOrEmpty(this.imurl) || ChannelHttpUtils.isNullOrEmpty(path)) {
            LOG.error("Not init IM SDK correctly. Do you forget init it?");
            throw new Exception("SDK url or secret lack!");
        }
        String url = this.imurl + path;
        HttpPost post = null;
        try {
            String line;
            int nonce = (int)(Math.random() * 100000.0 + 3.0);
            long timestamp = System.currentTimeMillis();
            String str = nonce + "|" + this.channelSecret + "|" + timestamp;
            String sign = DigestUtils.sha1Hex((String)str);
            post = new HttpPost(url);
            post.setHeader("Content-type", "application/json; charset=utf-8");
            post.setHeader("Connection", "Keep-Alive");
            post.setHeader("nonce", nonce + "");
            post.setHeader("timestamp", "" + timestamp);
            post.setHeader("cid", this.channelId);
            post.setHeader("sign", sign);
            String jsonStr = "";
            if (object != null) {
                jsonStr = gson.toJson(object);
            }
            LOG.info("http request:{} content: {}", (Object)url, (Object)jsonStr);
            StringEntity entity = new StringEntity(jsonStr, Charset.forName("UTF-8"));
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                LOG.info("Request error: " + statusCode);
                throw new Exception("Http request error with code:" + statusCode);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "utf-8"));
            StringBuffer sb = new StringBuffer();
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            in.close();
            String content = sb.toString();
            LOG.info("http request response content: {}", (Object)content);
            IMResult<T> iMResult = ChannelHttpUtils.fromJsonObject(content, clazz);
            return iMResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getChannelSecret() {
        return this.channelSecret;
    }
}

