'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var dayjs = require('dayjs');
var index$3 = require('../../button/index.js');
require('../../../hooks/index.js');
require('../../../utils/index.js');
require('../../../constants/index.js');
var dateTable = require('./date-table2.js');
var calendar = require('./calendar.js');
var pluginVue_exportHelper = require('../../../_virtual/plugin-vue_export-helper.js');
var index = require('../../../hooks/use-namespace/index.js');
var index$1 = require('../../../hooks/use-locale/index.js');
var event = require('../../../constants/event.js');
var error = require('../../../utils/error.js');
var index$2 = require('../../../hooks/use-deprecated/index.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var dayjs__default = /*#__PURE__*/_interopDefaultLegacy(dayjs);

const COMPONENT_NAME = "ElCalendar";
const __default__ = vue.defineComponent({
  name: COMPONENT_NAME
});
const _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...__default__,
  props: calendar.calendarProps,
  emits: calendar.calendarEmits,
  setup(__props, { expose, emit }) {
    const props = __props;
    const solts = vue.useSlots();
    const ns = index.useNamespace("calendar");
    const { t, lang } = index$1.useLocale();
    const selectedDay = vue.ref();
    const now = dayjs__default["default"]().locale(lang.value);
    const realSelectedDay = vue.computed({
      get() {
        if (!props.modelValue)
          return selectedDay.value;
        return date.value;
      },
      set(val) {
        if (!val)
          return;
        selectedDay.value = val;
        const result = val.toDate();
        emit(event.INPUT_EVENT, result);
        emit(event.UPDATE_MODEL_EVENT, result);
      }
    });
    const validatedRange = vue.computed(() => {
      if (!props.range)
        return [];
      const rangeArrDayjs = props.range.map((_) => dayjs__default["default"](_).locale(lang.value));
      const [startDayjs, endDayjs] = rangeArrDayjs;
      if (startDayjs.isAfter(endDayjs)) {
        error.debugWarn(COMPONENT_NAME, "end time should be greater than start time");
        return [];
      }
      if (startDayjs.isSame(endDayjs, "month")) {
        return calculateValidatedDateRange(startDayjs, endDayjs);
      } else {
        if (startDayjs.add(1, "month").month() !== endDayjs.month()) {
          error.debugWarn(COMPONENT_NAME, "start time and end time interval must not exceed two months");
          return [];
        }
        return calculateValidatedDateRange(startDayjs, endDayjs);
      }
    });
    const date = vue.computed(() => {
      if (!props.modelValue) {
        if (realSelectedDay.value) {
          return realSelectedDay.value;
        } else if (validatedRange.value.length) {
          return validatedRange.value[0][0];
        }
        return now;
      } else {
        return dayjs__default["default"](props.modelValue).locale(lang.value);
      }
    });
    const prevMonthDayjs = vue.computed(() => date.value.subtract(1, "month").date(1));
    const nextMonthDayjs = vue.computed(() => date.value.add(1, "month").date(1));
    const prevYearDayjs = vue.computed(() => date.value.subtract(1, "year").date(1));
    const nextYearDayjs = vue.computed(() => date.value.add(1, "year").date(1));
    const i18nDate = vue.computed(() => {
      const pickedMonth = `el.datepicker.month${date.value.format("M")}`;
      return `${date.value.year()} ${t("el.datepicker.year")} ${t(pickedMonth)}`;
    });
    const calculateValidatedDateRange = (startDayjs, endDayjs) => {
      const firstDay = startDayjs.startOf("week");
      const lastDay = endDayjs.endOf("week");
      const firstMonth = firstDay.get("month");
      const lastMonth = lastDay.get("month");
      if (firstMonth === lastMonth) {
        return [[firstDay, lastDay]];
      } else if (firstMonth + 1 === lastMonth) {
        const firstMonthLastDay = firstDay.endOf("month");
        const lastMonthFirstDay = lastDay.startOf("month");
        const isSameWeek = firstMonthLastDay.isSame(lastMonthFirstDay, "week");
        const lastMonthStartDay = isSameWeek ? lastMonthFirstDay.add(1, "week") : lastMonthFirstDay;
        return [
          [firstDay, firstMonthLastDay],
          [lastMonthStartDay.startOf("week"), lastDay]
        ];
      } else if (firstMonth + 2 === lastMonth || (firstMonth + 1) % 11 === lastMonth) {
        const firstMonthLastDay = firstDay.endOf("month");
        const secondMonthFirstDay = firstDay.add(1, "month").startOf("month");
        const secondMonthStartDay = firstMonthLastDay.isSame(secondMonthFirstDay, "week") ? secondMonthFirstDay.add(1, "week") : secondMonthFirstDay;
        const secondMonthLastDay = secondMonthStartDay.endOf("month");
        const lastMonthFirstDay = lastDay.startOf("month");
        const lastMonthStartDay = secondMonthLastDay.isSame(lastMonthFirstDay, "week") ? lastMonthFirstDay.add(1, "week") : lastMonthFirstDay;
        return [
          [firstDay, firstMonthLastDay],
          [secondMonthStartDay.startOf("week"), secondMonthLastDay],
          [lastMonthStartDay.startOf("week"), lastDay]
        ];
      } else {
        error.debugWarn(COMPONENT_NAME, "start time and end time interval must not exceed two months");
        return [];
      }
    };
    const pickDay = (day) => {
      realSelectedDay.value = day;
    };
    const selectDate = (type) => {
      let day;
      if (type === "prev-month") {
        day = prevMonthDayjs.value;
      } else if (type === "next-month") {
        day = nextMonthDayjs.value;
      } else if (type === "prev-year") {
        day = prevYearDayjs.value;
      } else if (type === "next-year") {
        day = nextYearDayjs.value;
      } else {
        day = now;
      }
      if (day.isSame(date.value, "day"))
        return;
      pickDay(day);
    };
    index$2.useDeprecated({
      from: '"dateCell"',
      replacement: '"date-cell"',
      scope: "ElCalendar",
      version: "2.3.0",
      ref: "https://element-plus.org/en-US/component/calendar.html#slots",
      type: "Slot"
    }, vue.computed(() => !!solts.dateCell));
    expose({
      selectedDay: realSelectedDay,
      pickDay,
      selectDate,
      calculateValidatedDateRange
    });
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createElementBlock("div", {
        class: vue.normalizeClass(vue.unref(ns).b())
      }, [
        vue.createElementVNode("div", {
          class: vue.normalizeClass(vue.unref(ns).e("header"))
        }, [
          vue.renderSlot(_ctx.$slots, "header", { date: vue.unref(i18nDate) }, () => [
            vue.createElementVNode("div", {
              class: vue.normalizeClass(vue.unref(ns).e("title"))
            }, vue.toDisplayString(vue.unref(i18nDate)), 3),
            vue.unref(validatedRange).length === 0 ? (vue.openBlock(), vue.createElementBlock("div", {
              key: 0,
              class: vue.normalizeClass(vue.unref(ns).e("button-group"))
            }, [
              vue.createVNode(vue.unref(index$3.ElButtonGroup), null, {
                default: vue.withCtx(() => [
                  vue.createVNode(vue.unref(index$3.ElButton), {
                    size: "small",
                    onClick: _cache[0] || (_cache[0] = ($event) => selectDate("prev-month"))
                  }, {
                    default: vue.withCtx(() => [
                      vue.createTextVNode(vue.toDisplayString(vue.unref(t)("el.datepicker.prevMonth")), 1)
                    ]),
                    _: 1
                  }),
                  vue.createVNode(vue.unref(index$3.ElButton), {
                    size: "small",
                    onClick: _cache[1] || (_cache[1] = ($event) => selectDate("today"))
                  }, {
                    default: vue.withCtx(() => [
                      vue.createTextVNode(vue.toDisplayString(vue.unref(t)("el.datepicker.today")), 1)
                    ]),
                    _: 1
                  }),
                  vue.createVNode(vue.unref(index$3.ElButton), {
                    size: "small",
                    onClick: _cache[2] || (_cache[2] = ($event) => selectDate("next-month"))
                  }, {
                    default: vue.withCtx(() => [
                      vue.createTextVNode(vue.toDisplayString(vue.unref(t)("el.datepicker.nextMonth")), 1)
                    ]),
                    _: 1
                  })
                ]),
                _: 1
              })
            ], 2)) : vue.createCommentVNode("v-if", true)
          ])
        ], 2),
        vue.unref(validatedRange).length === 0 ? (vue.openBlock(), vue.createElementBlock("div", {
          key: 0,
          class: vue.normalizeClass(vue.unref(ns).e("body"))
        }, [
          vue.createVNode(dateTable["default"], {
            date: vue.unref(date),
            "selected-day": vue.unref(realSelectedDay),
            onPick: pickDay
          }, vue.createSlots({ _: 2 }, [
            _ctx.$slots["date-cell"] || _ctx.$slots.dateCell ? {
              name: "date-cell",
              fn: vue.withCtx((data) => [
                _ctx.$slots["date-cell"] ? vue.renderSlot(_ctx.$slots, "date-cell", vue.normalizeProps(vue.mergeProps({ key: 0 }, data))) : vue.renderSlot(_ctx.$slots, "dateCell", vue.normalizeProps(vue.mergeProps({ key: 1 }, data)))
              ])
            } : void 0
          ]), 1032, ["date", "selected-day"])
        ], 2)) : (vue.openBlock(), vue.createElementBlock("div", {
          key: 1,
          class: vue.normalizeClass(vue.unref(ns).e("body"))
        }, [
          (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(vue.unref(validatedRange), (range_, index) => {
            return vue.openBlock(), vue.createBlock(dateTable["default"], {
              key: index,
              date: range_[0],
              "selected-day": vue.unref(realSelectedDay),
              range: range_,
              "hide-header": index !== 0,
              onPick: pickDay
            }, vue.createSlots({ _: 2 }, [
              _ctx.$slots["date-cell"] || _ctx.$slots.dateCell ? {
                name: "date-cell",
                fn: vue.withCtx((data) => [
                  _ctx.$slots["date-cell"] ? vue.renderSlot(_ctx.$slots, "date-cell", vue.normalizeProps(vue.mergeProps({ key: 0 }, data))) : vue.renderSlot(_ctx.$slots, "dateCell", vue.normalizeProps(vue.mergeProps({ key: 1 }, data)))
                ])
              } : void 0
            ]), 1032, ["date", "selected-day", "range", "hide-header"]);
          }), 128))
        ], 2))
      ], 2);
    };
  }
});
var Calendar = /* @__PURE__ */ pluginVue_exportHelper["default"](_sfc_main, [["__file", "/home/runner/work/element-plus/element-plus/packages/components/calendar/src/calendar.vue"]]);

exports["default"] = Calendar;
//# sourceMappingURL=calendar2.js.map
