import { inject, ref, computed, toRaw } from 'vue';
import '../../../../hooks/index.mjs';
import '../../../../utils/index.mjs';
import '../../../../tokens/index.mjs';
import { checkboxGroupContextKey } from '../../../../tokens/checkbox.mjs';
import { isBoolean } from '@vueuse/core';
import { isArray } from '@vue/shared';
import { useSize } from '../../../../hooks/use-common-props/index.mjs';

const useCheckboxStatus = (props, slots, { model }) => {
  const checkboxGroup = inject(checkboxGroupContextKey, void 0);
  const isFocused = ref(false);
  const isChecked = computed(() => {
    const value = model.value;
    if (isBoolean(value)) {
      return value;
    } else if (isArray(value)) {
      return value.map(toRaw).includes(props.label);
    } else if (value !== null && value !== void 0) {
      return value === props.trueLabel;
    } else {
      return !!value;
    }
  });
  const checkboxButtonSize = useSize(computed(() => {
    var _a;
    return (_a = checkboxGroup == null ? void 0 : checkboxGroup.size) == null ? void 0 : _a.value;
  }), {
    prop: true
  });
  const checkboxSize = useSize(computed(() => {
    var _a;
    return (_a = checkboxGroup == null ? void 0 : checkboxGroup.size) == null ? void 0 : _a.value;
  }));
  const hasOwnLabel = computed(() => {
    return !!(slots.default || props.label);
  });
  return {
    checkboxButtonSize,
    isChecked,
    isFocused,
    checkboxSize,
    hasOwnLabel
  };
};

export { useCheckboxStatus };
//# sourceMappingURL=use-checkbox-status.mjs.map
