import { defineComponent, computed, openBlock, createElementBlock, normalizeClass, unref, Fragment, renderList, toDisplayString, createCommentVNode, createElementVNode, renderSlot } from 'vue';
import dayjs from 'dayjs';
import localeData from 'dayjs/plugin/localeData.js';
import '../../../hooks/index.mjs';
import '../../time-picker/index.mjs';
import '../../../constants/index.mjs';
import { dateTableProps, dateTableEmits, getPrevMonthLastDays, getMonthDays, toNestedArr } from './date-table.mjs';
import _export_sfc from '../../../_virtual/plugin-vue_export-helper.mjs';
import { useLocale } from '../../../hooks/use-locale/index.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';
import { rangeArr } from '../../time-picker/src/utils.mjs';
import { WEEK_DAYS } from '../../../constants/date.mjs';

const _hoisted_1 = { key: 0 };
const _hoisted_2 = ["onClick"];
const __default__ = defineComponent({
  name: "DateTable"
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...__default__,
  props: dateTableProps,
  emits: dateTableEmits,
  setup(__props, { expose, emit }) {
    const props = __props;
    dayjs.extend(localeData);
    const { t, lang } = useLocale();
    const nsTable = useNamespace("calendar-table");
    const nsDay = useNamespace("calendar-day");
    const now = dayjs().locale(lang.value);
    const firstDayOfWeek = dayjs.localeData().firstDayOfWeek();
    const isInRange = computed(() => !!props.range && !!props.range.length);
    const rows = computed(() => {
      let days = [];
      if (isInRange.value) {
        const [start, end] = props.range;
        const currentMonthRange = rangeArr(end.date() - start.date() + 1).map((index) => ({
          text: start.date() + index,
          type: "current"
        }));
        let remaining = currentMonthRange.length % 7;
        remaining = remaining === 0 ? 0 : 7 - remaining;
        const nextMonthRange = rangeArr(remaining).map((_, index) => ({
          text: index + 1,
          type: "next"
        }));
        days = currentMonthRange.concat(nextMonthRange);
      } else {
        const firstDay = props.date.startOf("month").day();
        const prevMonthDays = getPrevMonthLastDays(props.date, (firstDay - firstDayOfWeek + 7) % 7).map((day) => ({
          text: day,
          type: "prev"
        }));
        const currentMonthDays = getMonthDays(props.date).map((day) => ({
          text: day,
          type: "current"
        }));
        days = [...prevMonthDays, ...currentMonthDays];
        const remaining = 7 - (days.length % 7 || 7);
        const nextMonthDays = rangeArr(remaining).map((_, index) => ({
          text: index + 1,
          type: "next"
        }));
        days = days.concat(nextMonthDays);
      }
      return toNestedArr(days);
    });
    const weekDays = computed(() => {
      const start = firstDayOfWeek;
      if (start === 0) {
        return WEEK_DAYS.map((_) => t(`el.datepicker.weeks.${_}`));
      } else {
        return WEEK_DAYS.slice(start).concat(WEEK_DAYS.slice(0, start)).map((_) => t(`el.datepicker.weeks.${_}`));
      }
    });
    const getFormattedDate = (day, type) => {
      switch (type) {
        case "prev":
          return props.date.startOf("month").subtract(1, "month").date(day);
        case "next":
          return props.date.startOf("month").add(1, "month").date(day);
        case "current":
          return props.date.date(day);
      }
    };
    const getCellClass = ({ text, type }) => {
      const classes = [type];
      if (type === "current") {
        const date = getFormattedDate(text, type);
        if (date.isSame(props.selectedDay, "day")) {
          classes.push(nsDay.is("selected"));
        }
        if (date.isSame(now, "day")) {
          classes.push(nsDay.is("today"));
        }
      }
      return classes;
    };
    const handlePickDay = ({ text, type }) => {
      const date = getFormattedDate(text, type);
      emit("pick", date);
    };
    const getSlotData = ({ text, type }) => {
      const day = getFormattedDate(text, type);
      return {
        isSelected: day.isSame(props.selectedDay),
        type: `${type}-month`,
        day: day.format("YYYY-MM-DD"),
        date: day.toDate()
      };
    };
    expose({
      getFormattedDate
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("table", {
        class: normalizeClass([unref(nsTable).b(), unref(nsTable).is("range", unref(isInRange))]),
        cellspacing: "0",
        cellpadding: "0"
      }, [
        !_ctx.hideHeader ? (openBlock(), createElementBlock("thead", _hoisted_1, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(unref(weekDays), (day) => {
            return openBlock(), createElementBlock("th", { key: day }, toDisplayString(day), 1);
          }), 128))
        ])) : createCommentVNode("v-if", true),
        createElementVNode("tbody", null, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(unref(rows), (row, index) => {
            return openBlock(), createElementBlock("tr", {
              key: index,
              class: normalizeClass({
                [unref(nsTable).e("row")]: true,
                [unref(nsTable).em("row", "hide-border")]: index === 0 && _ctx.hideHeader
              })
            }, [
              (openBlock(true), createElementBlock(Fragment, null, renderList(row, (cell, key) => {
                return openBlock(), createElementBlock("td", {
                  key,
                  class: normalizeClass(getCellClass(cell)),
                  onClick: ($event) => handlePickDay(cell)
                }, [
                  createElementVNode("div", {
                    class: normalizeClass(unref(nsDay).b())
                  }, [
                    renderSlot(_ctx.$slots, "date-cell", {
                      data: getSlotData(cell)
                    }, () => [
                      createElementVNode("span", null, toDisplayString(cell.text), 1)
                    ])
                  ], 2)
                ], 10, _hoisted_2);
              }), 128))
            ], 2);
          }), 128))
        ])
      ], 2);
    };
  }
});
var DateTable = /* @__PURE__ */ _export_sfc(_sfc_main, [["__file", "/home/runner/work/element-plus/element-plus/packages/components/calendar/src/date-table.vue"]]);

export { DateTable as default };
//# sourceMappingURL=date-table2.mjs.map
