const presetInitialIndentBrackets = {
    css: ['{', '}'],
    scss: ['{', '}'],
};
const plugin = () => {
    return {
        getEmbeddedFileNames(fileName, sfc) {
            const names = [];
            for (let i = 0; i < sfc.styles.length; i++) {
                const style = sfc.styles[i];
                names.push(fileName + '.style_' + i + '.' + style.lang);
            }
            return names;
        },
        resolveEmbeddedFile(fileName, sfc, embeddedFile) {
            const match = embeddedFile.fileName.match(/^(.*)\.style_(\d+)\.([^.]+)$/);
            if (match) {
                const index = parseInt(match[2]);
                const style = sfc.styles[index];
                embeddedFile.capabilities = {
                    diagnostics: true,
                    foldingRanges: true,
                    formatting: {
                        initialIndentBracket: presetInitialIndentBrackets[style.lang],
                    },
                    documentSymbol: true,
                    codeActions: true,
                    inlayHints: true,
                };
                embeddedFile.isTsHostFile = false;
                embeddedFile.codeGen.addCode2(style.content, 0, {
                    vueTag: style.tag,
                    vueTagIndex: index,
                    capabilities: {
                        basic: true,
                        references: true,
                        definitions: true,
                        diagnostic: true,
                        rename: true,
                        completion: true,
                        semanticTokens: true,
                    },
                });
            }
        },
    };
};
module.exports = plugin;
//# sourceMappingURL=vue-sfc-styles.js.map