const code_gen_1 = require("@volar/code-gen");
const source_map_1 = require("@volar/source-map");
const compiler_sfc_1 = require("@vue/compiler-sfc");
const plugin = () => {
    return {
        parseSFC(fileName, content) {
            if (fileName.endsWith('.md')) {
                content = content
                    // code block
                    .replace(/```[\s\S]*?```/g, match => '```' + ' '.repeat(match.length - 6) + '```')
                    // inline code block
                    .replace(/`[\s\S]*?`/g, match => `\`${' '.repeat(match.length - 2)}\``)
                    // # \<script setup>
                    .replace(/\\\<[\s\S]*?\>\n?/g, match => ' '.repeat(match.length));
                const sfcBlockReg = /\<(script|style)[\s\S]*?\>([\s\S]*?)\<\/\1\>/g;
                const codeGen = new code_gen_1.CodeGen();
                for (const match of content.matchAll(sfcBlockReg)) {
                    if (match.index !== undefined) {
                        const matchText = match[0];
                        codeGen.addCode2(matchText, match.index, undefined);
                        codeGen.addText('\n\n');
                        content = content.substring(0, match.index) + ' '.repeat(matchText.length) + content.substring(match.index + matchText.length);
                    }
                }
                content = content
                    // angle bracket: <http://foo.com>
                    .replace(/\<\S*\:\S*\>/g, match => ' '.repeat(match.length))
                    // [foo](http://foo.com)
                    .replace(/\[[\s\S]*?\]\([\s\S]*?\)/g, match => ' '.repeat(match.length));
                codeGen.addText('<template>\n');
                codeGen.addCode2(content, 0, undefined);
                codeGen.addText('\n</template>');
                const file2VueSourceMap = new source_map_1.SourceMapBase(codeGen.mappings);
                const sfc = (0, compiler_sfc_1.parse)(codeGen.getText(), { sourceMap: false, ignoreEmpty: false });
                if (sfc.descriptor.template) {
                    transformRange(sfc.descriptor.template);
                }
                if (sfc.descriptor.script) {
                    transformRange(sfc.descriptor.script);
                }
                if (sfc.descriptor.scriptSetup) {
                    transformRange(sfc.descriptor.scriptSetup);
                }
                for (const style of sfc.descriptor.styles) {
                    transformRange(style);
                }
                for (const customBlock of sfc.descriptor.customBlocks) {
                    transformRange(customBlock);
                }
                return sfc;
                function transformRange(block) {
                    var _a;
                    const fileRange = (_a = file2VueSourceMap.getSourceRange(block.loc.start.offset, block.loc.end.offset)) === null || _a === void 0 ? void 0 : _a[0];
                    if (fileRange) {
                        block.loc.start.offset = fileRange.start;
                        block.loc.end.offset = fileRange.end;
                    }
                    else {
                        block.loc.start.offset = -1;
                        block.loc.end.offset = -1;
                    }
                }
            }
            ;
        }
    };
};
module.exports = plugin;
//# sourceMappingURL=file-md.js.map