Object.defineProperty(exports, "__esModule", { value: true });
exports.createDocumentRegistry = void 0;
const reactivity_1 = require("@vue/reactivity");
const path_1 = require("path");
const localTypes = require("./utils/localTypes");
function createDocumentRegistry() {
    return createDocumentRegistryBase();
}
exports.createDocumentRegistry = createDocumentRegistry;
function createDocumentRegistryBase() {
    const files = (0, reactivity_1.shallowReactive)({});
    const all = (0, reactivity_1.computed)(() => Object.values(files));
    const fileNames = (0, reactivity_1.computed)(() => all.value.map(sourceFile => sourceFile.fileName));
    const embeddedDocumentsMap = (0, reactivity_1.computed)(() => {
        const map = new WeakMap();
        for (const sourceFile of all.value) {
            for (const embedded of sourceFile.allEmbeddeds) {
                map.set(embedded.file, sourceFile);
            }
        }
        return map;
    });
    const sourceMapsByFileName = (0, reactivity_1.computed)(() => {
        const map = new Map();
        for (const sourceFile of all.value) {
            for (const embedded of sourceFile.allEmbeddeds) {
                map.set(embedded.file.fileName.toLowerCase(), { vueFile: sourceFile, embedded });
            }
        }
        return map;
    });
    const teleports = (0, reactivity_1.computed)(() => {
        const map = new Map();
        for (const key in files) {
            const sourceFile = files[key];
            for (const embedded of sourceFile.allEmbeddeds) {
                if (embedded.teleport) {
                    map.set(embedded.file.fileName.toLowerCase(), embedded.teleport);
                }
            }
        }
        return map;
    });
    const dirs = (0, reactivity_1.computed)(() => [...new Set(fileNames.value.map(path_1.posix.dirname))]);
    return {
        get: (fileName) => files[fileName.toLowerCase()],
        delete: (fileName) => delete files[fileName.toLowerCase()],
        has: (fileName) => !!files[fileName.toLowerCase()],
        set: (fileName, vueFile) => files[fileName.toLowerCase()] = vueFile,
        getFileNames: () => fileNames.value,
        getDirs: () => dirs.value,
        getAll: () => all.value,
        getTeleport: (fileName) => teleports.value.get(fileName.toLowerCase()),
        getAllEmbeddeds: function* () {
            for (const sourceMap of sourceMapsByFileName.value) {
                yield sourceMap[1];
            }
        },
        fromEmbeddedLocation: function* (fileName, start, end, filter, sourceMapFilter) {
            if (fileName.endsWith(`/${localTypes.typesFileName}`))
                return;
            if (end === undefined)
                end = start;
            const mapped = sourceMapsByFileName.value.get(fileName.toLowerCase());
            if (mapped) {
                if (sourceMapFilter && !sourceMapFilter(mapped.embedded.sourceMap))
                    return;
                for (const vueRange of mapped.embedded.sourceMap.getSourceRanges(start, end, filter)) {
                    yield {
                        fileName: mapped.vueFile.fileName,
                        range: vueRange[0],
                        mapped: mapped,
                        data: vueRange[1],
                    };
                }
            }
            else {
                yield {
                    fileName,
                    range: {
                        start,
                        end,
                    },
                };
            }
        },
        fromEmbeddedFile: function (file) {
            return embeddedDocumentsMap.value.get(file);
        },
        fromEmbeddedFileName: function (fileName) {
            return sourceMapsByFileName.value.get(fileName.toLowerCase());
        },
    };
}
//# sourceMappingURL=documentRegistry.js.map