import type { EmbeddedFileMappingData } from './types';
import type { EmbeddedFileSourceMap, Teleport } from './utils/sourceMaps';
import type { Embedded, EmbeddedFile, SourceFile } from './sourceFile';
export interface DocumentRegistry extends ReturnType<typeof createDocumentRegistry> {
}
export interface EmbeddedLangaugeSourceFile {
    fileName: string;
    text: string;
    allEmbeddeds: Embedded[];
}
export declare function createDocumentRegistry(): {
    get: (fileName: string) => SourceFile;
    delete: (fileName: string) => boolean;
    has: (fileName: string) => boolean;
    set: (fileName: string, vueFile: SourceFile) => SourceFile;
    getFileNames: () => string[];
    getDirs: () => string[];
    getAll: () => SourceFile[];
    getTeleport: (fileName: string) => Teleport | undefined;
    getAllEmbeddeds: () => Generator<{
        vueFile: SourceFile;
        embedded: Embedded;
    }, void, unknown>;
    fromEmbeddedLocation: (fileName: string, start: number, end?: number | undefined, filter?: ((data: EmbeddedFileMappingData) => boolean) | undefined, sourceMapFilter?: ((sourceMap: EmbeddedFileSourceMap) => boolean) | undefined) => Generator<{
        fileName: string;
        range: {
            start: number;
            end: number;
        };
        mapped: {
            vueFile: SourceFile;
            embedded: Embedded;
        };
        data: EmbeddedFileMappingData;
    } | {
        fileName: string;
        range: {
            start: number;
            end: number;
        };
        mapped?: undefined;
        data?: undefined;
    }, void, unknown>;
    fromEmbeddedFile: (file: EmbeddedFile) => SourceFile | undefined;
    fromEmbeddedFileName: (fileName: string) => {
        vueFile: SourceFile;
        embedded: Embedded;
    } | undefined;
};
