package com.bcxin.ars.webservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.RSACoder;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.dto.GXTokenDto;
import com.xiaoleilu.hutool.http.HttpResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.http.Method;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.*;

/**
 * 广西背景筛查
 *
 * @author linqinglin
 * @date 2019/04/17 0017 17:48
 */
@Service("backGroupCensorService_450000")
public class GXBackGroupCensorServiceImpl extends BackGroupCensorServiceImpl implements BackGroupCensorService {

    private static Logger logger = LoggerFactory.getLogger(GXBackGroupCensorServiceImpl.class);

    @Autowired
    private BjRestLogDao bjRestLogDao;

    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Autowired
    private ConfigService configService;

    @Autowired
    private SecurityPersonService securityPersonService;

    @Autowired
    private RedisUtil redisUtil;


    private static final String REDIS_TOKEN_KEY = "gx_censor_token";

    private static final String URL_TOKEN = "http://71.4.151.23:8080/api/oauth2/oauth/token";

    private static final String URL_COMPARISON = "http://71.4.151.23:8080/api/importantPersonnel/importantPersonnel/";
    //private static final String URL_COMPARISON = "http://71.4.151.23:8080/api/protection/data/importantPersonnel/";

    private static String URL_VALIDATE = "http://10.148.67.119:9088/gxryhy/sfhc/integrityValidate.action";

    private static final String PWD_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCWA1dKytyglYlK4nTprfKEeECTHsNBmxn0GkdW6/xlsKIXCPKDFtmYjNqIqq5K8+qNyvnIVEymxapLQqkLev4eee9kdqfkvU9QnLm64Ut4YWxo3ewBfygT0ALOKuuG0ItVGrRBwJdPfTI4SoJidCTBI7lOIoHYIRYomi5ijyXQJQIDAQAB";

    @Override
    public String getPhoto(String idnum, String name) {
        try {

            SecurityPerson person = securityPersonService.findByIdCard(idnum);
            if (person != null) {
                if (StringUtil.isNotEmpty(person.getIdPhoto())) {
                    return person.getIdPhoto();
                } else {
                    return person.getPhoto();
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new ArsException("获取人口库照片信息失败！");
        }

        return StringUtil.EMPTY;
    }

    /**
     * 广西人口信息管理系统-常住人口信息查询服务	gxtqdsj_R-450000230000-00002892
     * 获取人口库信息
     *
     * @param idnum
     * @return
     */
    @Override
    public PersonBaseInfo getPopulationInfo(String idnum, boolean needPhoto) {
        PersonBaseInfo personBaseInfo = null;
        try {
            SecurityPerson person = securityPersonService.findByIdCard(idnum);
            if (person != null) {
                personBaseInfo = new PersonBaseInfo();
                personBaseInfo.setIdnum(person.getIdNumber());
                personBaseInfo.setName(person.getRealName());
                if (needPhoto) {
                    if (StringUtil.isNotEmpty(person.getIdPhoto())) {
                        personBaseInfo.setPhoto(person.getIdPhoto());
                    } else {
                        personBaseInfo.setPhoto(person.getPhoto());
                    }
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new ArsException("获取人口库信息失败！");
        }

        return personBaseInfo;
    }


    @Override
    public List<BackgroundApproval> censorFromBase(BackgroundApprovalDto dto, boolean needCZ) {
        Long businessid = dto.getBusinessid();
        String businesstype = dto.getBusinesstype();
        String idNumber = dto.getIdNumber();
        String name = dto.getRealName();
        List<BackgroundApproval> list = new ArrayList<>();
        try {
            BackgroundApproval cz_BackgroundApproval = new BackgroundApproval();
            cz_BackgroundApproval.setActive(true);
            cz_BackgroundApproval.setCreateTime(new Date());
            cz_BackgroundApproval.setUpdateTime(new Date());
            cz_BackgroundApproval.setBusinessid(businessid);
            cz_BackgroundApproval.setApprovaldate(new Date());
            cz_BackgroundApproval.setBusinesstype(businesstype);
            BackgroundApproval tempBackgroundApproval = cz_BackgroundApproval.clone();

            if(needCZ) {
                boolean policeInterface = true;

                if (!Constants.AUTH_STATE_PASS.equals(dto.getAuthState())) {
                    if(Constants.BAYZ.equals(businesstype)){
                        SecurityPerson person = securityPersonDao.findByIdCardAndActive(idNumber);
                        if(person != null && Constants.AUTH_STATE_PASS.equals(person.getIdentityAuthState())){
                            policeInterface = false;
                        }
                    }
                }else{
                    policeInterface = false;
                }

                if(policeInterface){
                    gxCensorCZ(idNumber, name, cz_BackgroundApproval);
                }else{
                    cz_BackgroundApproval.setApprovalreason("主项信息符合");
                    cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }
                list.add(cz_BackgroundApproval);
            }

            isKeyPerson(list, idNumber, tempBackgroundApproval.clone());
        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), e);
            throw new ArsException("查询人口库异常！");
        }
        return list;
    }

    private void gxCensorCZ(String idnum, String name, BackgroundApproval cz_BackgroundApproval) {

        CloseableHttpClient httpClient = HttpClients.createDefault();
        ResponseHandler<String> responseHandler = new BasicResponseHandler();

        try {
            String key = DateUtil.getCurrentDate(DateUtil.FORMAT11) + "_GXMATCH";
            String count = redisUtil.get(key);
            if (StringUtil.isNotEmpty(count)) {
                Long total = Long.parseLong(count);
                Long max = 8000L;
                try {
                    String configValue = configService.getValueByKey(Constants.POLICE_INTERFACE_MAX);
                    max = Long.parseLong(configValue);
                } catch (Exception e) {

                }
                if (total >= max) {
                    logger.error("广西人口库比对，请求次数超过最大次数:{}", max);
                    return;
                }
            }

            //数据保留7天
            redisUtil.getCount(key, 7L);
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("sh_name", name);
            paramMap.put("sh_sfz", idnum);
            paramMap.put("qiyebianma", "baoanbcx");
            paramMap.put("shid", "baoanbcx");
            paramMap.put("sh_zhaopian", "/9j/4AA");

            Map<String, Object> requestParamMap = new HashMap();
            requestParamMap.put("param", paramMap);


            logger.error("广西人口库比对，请求地址:{}", URL_VALIDATE);
            logger.error("广西人口库比对，请求参数:{}", JSON.toJSONString(requestParamMap));


            //第一步：创建HttpClient对象
            httpClient = HttpClients.createDefault();
            //第二步：创建httpPost对象
            HttpPost httpPost = new HttpPost(URL_VALIDATE);

            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(30000);
            requestConfig.setConnectionRequestTimeout(30000);
            requestConfig.setSocketTimeout(30000);
            //第三步：给httpPost设置JSON格式的参数
            StringEntity requestEntity = new StringEntity(JSON.toJSONString(requestParamMap), "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setConfig(requestConfig.build());

            httpPost.setEntity(requestEntity);

            //第四步：发送HttpPost请求，获取返回值
            String result = httpClient.execute(httpPost, responseHandler); //调接口获取返回值时，必须用此方法

            logger.error("广西人口库比对，返回结果:{}", result);

            //增加日志
            BjRestLog log = new BjRestLog();
            log.setResttype("GXMATCH");
            log.setResponseContext(result);
            log.setRequestContext(JSON.toJSONString(requestParamMap));
            //创建时间
            log.setCreateTime(new Date());
            //有效标记
            log.setActive(true);
            //更新时间
            log.setUpdateTime(new Date());
            //更新者
            log.setUpdateBy(Constants.APPROVAL_SYSTEM);
            bjRestLogDao.save(log);

            if (StringUtil.isNotEmpty(result)) {
                JSONObject resultObj = JSON.parseObject(result);
                if (resultObj.get("shjg") != null) {
                    //JSONObject resData = JSON.parseObject(resultObj.get("resData").toString());
                    String comparisonResult = resultObj.get("shjg").toString();
                    //0比对不通过，1比对通过 11是错误 （身份证号码和姓名不符） 20身份证号码不存在
                    switch (comparisonResult) {
                        case "11":
                            if(resultObj.get("msg") == null || resultObj.get("msg").toString().contains("姓名与证件号码不匹配")){
                                cz_BackgroundApproval.setApprovalreason(Constants.LIBRARYTYPE_CZ_FAIL_MESSAGE);
                                cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                                cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                            }else{
                                cz_BackgroundApproval.setApprovalreason("主项信息符合");
                                cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                                cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                            }
                            break;
                        case "20":
                            cz_BackgroundApproval.setApprovalreason(Constants.LIBRARYTYPE_CZ_FAIL);
                            cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                            cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                            break;
                        default:
                            cz_BackgroundApproval.setApprovalreason("主项信息符合");
                            cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                            cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                            break;
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new ArsException("广西人口库比对失败");
        } finally {
            try {
                httpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 广西【重点人员】
     * <p>
     * 成功:
     * {
     *     "requestId": "a3b7d1f5-af03-44d8-9e22-1e85b9cb072d",
     *     "success": true,
     *     "code": "200",
     *     "message": "OK",
     *     "data": "05"   //重点人员类型,多种类型有逗号分隔 例如: 04,05,06
     * }
     * 失败:
     * {
     *     "code": "401",   //401表示凭证过期,需要重新调用获取新的凭证
     *     "message": "用户身份过期,请重新登录!",
     *     "requestId": "f3b8e5a8-139b-40d4-971d-f7975d131627",
     *     "success": false
     * }
     * {
     * "code": "500",   //500表示接口异常,请联系接口负责人
     * "message": "系统异常!",
     *     "requestId": "f3b8e5a8-139b-40d4-971d-f7975d131627",
     *     "success": false
     * }
     * <p>
     * 字典	报警类型名称
     * 00	正常
     * 01	涉恐人员
     * 02	涉稳人员
     * 03	在逃人员
     * 04	涉毒人员
     * 05	刑事犯罪前科人员报警
     * 06	肇事肇祸精神病人
     * 07	重点上访人员
     *
     * @param list
     * @param idnum
     * @param backgroundApproval
     */
    private void isKeyPerson(List<BackgroundApproval> list, String idnum, BackgroundApproval backgroundApproval) {
        try {

            String key = DateUtil.getCurrentDate(DateUtil.FORMAT11) + "_GXCOMPARISON";
            String count = redisUtil.get(key);
            if (StringUtil.isNotEmpty(count)) {
                Long total = Long.parseLong(count);
                Long max = 8000L;
                try {
                    String configValue = configService.getValueByKey(Constants.POLICE_INTERFACE_MAX);
                    max = Long.parseLong(configValue);
                } catch (Exception e) {

                }
                if (total >= max) {
                    logger.error("广西重点人比对，请求次数超过最大次数:{}", max);
                    return;
                }
            }

            String url = URL_COMPARISON + idnum;
            String token = getToken(false);
            logger.error("广西重点人比对，请求地址:{}", url);
            //构建请求
            HttpResponse response = HttpUtil
                    .createRequest(Method.POST, url)
                    //设置三十秒超时时间
                    .timeout(Constants.BEIJING_CHECK_PERSON_BASE_INFO_TIMEOUT)
                    .header("Authorization", token)
                    .execute();
            String result = response.body();
            logger.error("广西重点人比对，返回结果:{}", result);


            //增加日志
            BjRestLog log = new BjRestLog();
            log.setResttype("GXCOMPARISON");
            log.setResponseContext(result);
            log.setRequestContext(idnum);
            //创建时间
            log.setCreateTime(new Date());
            //有效标记
            log.setActive(true);
            //更新时间
            log.setUpdateTime(new Date());
            //更新者
            log.setUpdateBy(Constants.APPROVAL_SYSTEM);
            bjRestLogDao.save(log);


            if (StringUtil.isNotEmpty(result)) {
                JSONObject resultObj = JSON.parseObject(result);
                if (resultObj.get("code") != null) {
                    if ("200".equals(resultObj.get("code").toString())) {
                        BackgroundApproval xd_BackgroundApproval = backgroundApproval.clone();
                        xd_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_XD);
                        BackgroundApproval dt_BackgroundApproval = backgroundApproval.clone();
                        dt_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_DT);
                        BackgroundApproval wf_BackgroundApproval = backgroundApproval.clone();
                        wf_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_WF);


                        boolean xd = false,
                                dt = false,
                                wf = false;
                        StringBuilder content = new StringBuilder();
                        if (resultObj.get("data") != null) {
                            String data = resultObj.get("data").toString();
                            if (!"00".equals(data)) {
                                String[] datas = data.split(",");
                                for (String s : datas) {
                                    if ("03".equals(s)) {
                                        dt = true;
                                    } else if ("04".equals(s)) {
                                        xd = true;
                                    } else if ("05".equals(s)) {
                                        wf = true;
                                        content.append("刑事犯罪前科人员报警、");
                                    } else if ("06".equals(s)) {
                                        wf = true;
                                        content.append("肇事肇祸精神病人、");
                                    } else if ("07".equals(s)) {
                                        wf = true;
                                        content.append("重点上访人员、");
                                    } else if ("01".equals(s)) {
                                        wf = true;
                                        content.append("涉恐人员、");
                                    } else if ("02".equals(s)) {
                                        wf = true;
                                        content.append("涉稳人员、");
                                    }
                                }
                            }
                        }

                        if (xd) {
                            xd_BackgroundApproval.setApprovalreason("吸毒人员");
                            xd_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                            xd_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                        } else {
                            xd_BackgroundApproval.setApprovalreason("无吸毒记录");
                            xd_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                            xd_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                        }

                        if (dt) {
                            dt_BackgroundApproval.setApprovalreason("在逃人员");
                            dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                            dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                        } else {
                            dt_BackgroundApproval.setApprovalreason("无在逃记录");
                            dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                            dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                        }

                        if (wf) {
                            wf_BackgroundApproval.setApprovalreason(content.substring(0, content.length() - 1));
                            wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                            wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                        } else {
                            wf_BackgroundApproval.setApprovalreason("无违法犯罪记录");
                            wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                            wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                        }

                        list.add(xd_BackgroundApproval);
                        list.add(dt_BackgroundApproval);
                        list.add(wf_BackgroundApproval);
                    } else if ("401".equals(resultObj.get("code").toString())) {
                        getToken(true);
                        isKeyPerson(list, idnum, backgroundApproval);
                    } else {
                        try {
                            throw new ArsException("广西重点人比对接口异常,请联系接口负责人:" + resultObj.get("message").toString());
                        } catch (Exception e) {
                            e.printStackTrace();
                            logger.error(e.getMessage());
                            throw new ArsException("广西重点人比对获取token失败");
                        }
                    }
                }

            }


        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), e);
            throw new ArsException("广西【广西重点人比对】调用异常！！");
        }
    }

    /**
     * @return
     */
    private synchronized String getToken(boolean refresh) {
        String token = redisUtil.get(REDIS_TOKEN_KEY);
        if (refresh || StringUtil.isEmpty(token)) {
            try {
                Map<String, Object> paramMap = new HashMap<>();
                paramMap.put("username", "bcxzdr");
                paramMap.put("password", RSACoder.encrypt("bcxzdr123", PWD_PUBLIC_KEY));
                paramMap.put("grant_type", "password");

                logger.error("广西重点人比对获取token，请求地址:{}", URL_TOKEN);
                logger.error("广西重点人比对获取token，请求参数:{}", JSON.toJSONString(paramMap));
                //构建请求
                HttpResponse response = HttpUtil
                        .createRequest(Method.POST, URL_TOKEN)
                        .form(paramMap)
                        //设置三十秒超时时间
                        .timeout(Constants.BEIJING_CHECK_PERSON_BASE_INFO_TIMEOUT)
                        .header("Content-Type", "application/x-www-form-urlencoded")
                        .header("Authorization", "Basic YWRtaW46UklmZmY3WFpYTEZDR2hHM0lOZm5KRis0NjN2WTFnd25PTHgrSWlQYUtQK0lnV0k5aUR5c0VTS0JERDJGNkVxWVZXVS9GVTA2cnNDeE1IWFgvMWJCazN4dk9TR0NtWEJ3d0dsSUNJclg4VFEvdHBmRkU5M2NjZmkrakdEQ2lLOHFWbmRhUG5TaU1yYk00cUZud25TeGF5amp6SDVrSlZkcVZ2YnJSWVZLL3NVPQ==")
                        .execute();
                String result = response.body();
                logger.error("广西重点人比对获取token，返回结果:{}", result);
                //GXTokenDto tokenDto = JSON.parseObject(result, GXTokenDto.class);
                //logger.error("广西重点人比对获取token，返回结果:{}", tokenDto);
                if (StringUtil.isNotEmpty(result)) {
                    JSONObject data = JSON.parseObject(result);
                    token = data.get("access_token").toString();
                    redisUtil.set(REDIS_TOKEN_KEY, token, 29 * 60);
                } else {
                    throw new ArsException("广西重点人比对获取token失败:" + result);
                }
            } catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage());
                throw new ArsException("广西重点人比对获取token失败");
            }
        }
        logger.error("请求token:{}", token);
        return token;
    }


    public static void main(String[] args) throws Exception {

        System.out.println(RSACoder.encrypt("bcxzdr123", PWD_PUBLIC_KEY));

        String result = "{" +
                "\"requestId\":\"56c84a85-48fe-47b1-bde8-ab7a45b63526\"," +
                "\"success\":true," +
                "\"code\":\"200\"," +
                "\"message\":\"OK\"," +
                "\"data\":{" +
                "\"access_token\":\"Bearer eyJhbGciOiJSUzI1NiJ9.eyJ\"," +
                "\"sub\":\"88888\"," +
                "\"expire\":\"2020-08-10 16:25:12\"," +
                "\"userType\":\"superAdmin\"," +
                "\"depart\":\"45\"," +
                "\"userName\":\"88888\"," +
                "\"userId\":\"1\"" +
                "}" +
                "}";

        System.out.println(result);
        if (StringUtil.isNotEmpty(result)) {
            GXTokenDto tokenDto = JSON.parseObject(result, GXTokenDto.class);
            System.out.println(tokenDto);
            JSONObject resultObj = JSON.parseObject(result);
            if (resultObj.get("code") != null && "200".equals(resultObj.get("code").toString())) {
                JSONObject data = JSON.parseObject(resultObj.get("data").toString());
                System.out.println(data.get("access_token").toString());
            }
        }
    }

}
