package com.bcxin.ars.webservice.util;

import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.util.Constants;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.http.HttpResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.http.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

/**
 * @author linqinglin
 * @date 2021/03/09 0009 15:40
 */
@Service
public class BJProblemDetailUtil {

    private static Logger logger = LoggerFactory.getLogger(BJProblemDetailUtil.class);


    @Autowired
    private BjRestLogDao bjRestLogDao;
    /**
     * 核查详情
     * 核查违法犯罪接口地址：http://14.62.1.210:9006/zzxt/jk/helu/checkPersonWffzInfo
     * 接口参数:
     * deviceid=60:EB:69:8F:82:9C
     * policesfzh=110101197002285038
     * policename=李京海
     * sfzh=被查询人的身份证号
     * 接口请求头:
     * uid=1100002200000700
     * username=baxt
     * userpwd=Bzxt*bzxt
     * 返回值:
     * {
     * "uuid": "bca0d07e-c5ad-4be6-92de-867e650474f7",
     * "msg": "ok",
     * "status": 0,
     * "results": [
     * {
     * "value": "违法犯罪(其他)",
     * "disposalWay": "",
     * "color": "yellow",
     * "resourceName": "违法犯罪",
     * "order": "2",
     * "key": "criminalType"
     * }
     * ]
     * }
     *
     * @param idNumber
     */
    public String checkPersonInfo( String idNumber) {
        try {

            //请求参数
            Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(8);
            //mac地址 固定值
            paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_DEVICE_ID, Constants.BEIJING_DEVICE_ID);
            //查询民警身份证号 固定值
            paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_POLICE_IDENTITY_NUMBER, Constants.POLICESFZH);
            //查询民警姓名 固定值
            paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_POLICE_NAME, Constants.POLICENAME);
            //被查询人员的身份证号
            paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_BE_QUERIED_IDENTITY_NUMBER, idNumber);

            //构建请求
            HttpResponse response = HttpUtil
                    .createRequest(Method.GET, Constants.BEIJING_CHECK_PERSON_WFFZ_INFO_URL)
                    .form(paramMap)
                    //设置三十秒超时时间
                    .timeout(Constants.BEIJING_CHECK_PERSON_BASE_INFO_TIMEOUT)
                    //需携带请求头uid 固定值
                    .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_UID, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_UID_VALUE)
                    //请求头username 固定值
                    .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USERNAME, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USERNAME_VALUE)
                    //请求头user pwd 固定值
                    .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USER_PWD, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USER_PWD_VALUE)
                    .execute();
            String result = response.body();

            //增加日志
            BjRestLog log = new BjRestLog();
            log.setResttype("ProblemDetail");
            log.setResponseContext(result);
            log.setRequestContext(paramMap.toString());
            //创建时间
            log.setCreateTime(new Date());
            //有效标记
            log.setActive(true);
            //更新时间
            log.setUpdateTime(new Date());
            //更新者
            log.setUpdateBy(Constants.APPROVAL_SYSTEM);
            bjRestLogDao.save(log);

            logger.error("身份证号:{},北京核查违法犯罪库返回数据:{}", idNumber, result);
            return result;
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new ArsException("北京核查库调用异常！！");

        }
    }
}
