/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util.poi;

import java.io.IOException;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.springframework.util.StringUtils;

public class ExcelUtil {
    public static String getCellValue(Cell cell) {
        String cellValue = "";
        DataFormatter formatter = new DataFormatter();
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: {
                    int intValue;
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        cellValue = formatter.formatCellValue(cell);
                        break;
                    }
                    double value = cell.getNumericCellValue();
                    cellValue = value - (double)(intValue = (int)value) == 0.0 ? String.valueOf(intValue) : String.valueOf(value);
                    break;
                }
                case 1: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case 4: {
                    cellValue = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case 2: {
                    cellValue = String.valueOf(cell.getCellFormula());
                    break;
                }
                case 3: {
                    cellValue = "";
                    break;
                }
                case 5: {
                    cellValue = "";
                    break;
                }
                default: {
                    cellValue = cell.toString().trim();
                }
            }
        }
        return cellValue.trim();
    }

    public static HSSFDataValidation setDataValidation(String strFormula, int firstRow, int endRow, int firstCol, int endCol) {
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        DVConstraint constraint = DVConstraint.createFormulaListConstraint((String)strFormula);
        HSSFDataValidation dataValidation = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
        dataValidation.createErrorBox("Error", "Error");
        dataValidation.createPromptBox("", null);
        return dataValidation;
    }

    public static CellStyle getNecessaryTitleStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        font.setFontHeightInPoints((short)12);
        font.setColor((short)2);
        style.setFont((Font)font);
        style.setFillPattern((short)1);
        style.setFillForegroundColor((short)22);
        style.setAlignment((short)2);
        HSSFDataFormat format = wb.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        return style;
    }

    public static CellStyle getCommonTitleStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        font.setFontHeightInPoints((short)12);
        style.setFont((Font)font);
        style.setFillPattern((short)1);
        style.setFillForegroundColor((short)22);
        style.setAlignment((short)2);
        HSSFDataFormat format = wb.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        return style;
    }

    public static CellStyle getExportStyle(Workbook wb, short size) {
        CellStyle style = wb.createCellStyle();
        Font font = wb.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints(size);
        style.setFont(font);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        DataFormat format = wb.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        style.setWrapText(true);
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        style.setBorderTop((short)1);
        style.setBorderRight((short)1);
        return style;
    }

    public static CellStyle getExportHeadStyle(Workbook wb, short fontSize, String weight, String center) {
        CellStyle style = wb.createCellStyle();
        Font font = wb.createFont();
        font.setFontName("\u5b8b\u4f53");
        if (weight.equals("1")) {
            font.setBoldweight((short)700);
        }
        if (center.equals("1")) {
            style.setAlignment((short)2);
        }
        style.setVerticalAlignment((short)1);
        style.setWrapText(true);
        font.setFontHeightInPoints(fontSize);
        style.setFont(font);
        DataFormat format = wb.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        return style;
    }

    public static void setStyleCell(Row rowTitle, int i, String value, CellStyle style) {
        Cell cell = rowTitle.createCell(i);
        cell.setCellValue(value);
        cell.setCellStyle(style);
    }

    public static CellStyle getImportStyle(Workbook wb, short fontSize, String fontName) {
        CellStyle cellStyle = wb.createCellStyle();
        Font font = wb.createFont();
        if (!StringUtils.isEmpty((Object)fontName)) {
            font.setFontName(fontName);
        }
        font.setFontHeightInPoints(fontSize);
        cellStyle.setFont(font);
        cellStyle.setWrapText(true);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderTop((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        return cellStyle;
    }

    public static CellStyle getContext(Workbook wb, short fontSize, String fontName) {
        CellStyle cellStyle = wb.createCellStyle();
        Font font = wb.createFont();
        if (!StringUtils.isEmpty((Object)fontName)) {
            font.setFontName(fontName);
        }
        font.setFontHeightInPoints(fontSize);
        cellStyle.setFont(font);
        cellStyle.setWrapText(true);
        return cellStyle;
    }

    public static CellStyle getStringStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        return style;
    }

    public static void region(int sheetIx, int firstRow, int lastRow, int firstCol, int lastCol, Workbook workbook) {
        Sheet sheet = workbook.getSheetAt(sheetIx);
        sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    public boolean isRowNull(int sheetIx, int rowIndex, HSSFWorkbook workbook) throws IOException {
        HSSFSheet sheet = workbook.getSheetAt(sheetIx);
        return sheet.getRow(rowIndex) == null;
    }

    public static boolean setValueAt(CellStyle cellStyle, int rowIndex, int colIndex, String value, HSSFWorkbook workbook, HSSFRow row) throws IOException {
        HSSFCell col = row.createCell(colIndex);
        col.setCellValue((RichTextString)new HSSFRichTextString(value));
        col.setCellStyle(cellStyle);
        return true;
    }

    public static CellStyle getExampleStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        font.setFontHeightInPoints((short)10);
        style.setFont((Font)font);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setWrapText(true);
        return style;
    }

    public static CellStyle getExample1Style(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        font.setBoldweight((short)700);
        font.setFontHeightInPoints((short)14);
        style.setFont((Font)font);
        style.setAlignment((short)1);
        style.setVerticalAlignment((short)1);
        style.setWrapText(true);
        return style;
    }
}

