<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE html>
<html>
<head>
<%@include file="/WEB-INF/views/include/head.jsp"%>
<link href="${ctxStatic }/css/plugins/bootstrap-table/bootstrap-table.min.css?v=${version}" rel="stylesheet">
</head>
<body class="gray-bg">
	<div class="wrapper wrapper-content animated fadeInRight">
		<div class="row">
			<div class="col-sm-12">
				<div class="ibox float-e-margins">
					<div class="ibox-content">
						<form id="searchForm" class="form-horizontal">
							<div class="form-group">
								<label class="col-sm-1 control-label">审批内容</label>
								<div class="col-sm-2">
									<input type="text" class="form-control" id="context" name="context">
								</div>
								<label class="col-sm-1 control-label">业务类型</label>
								<div class="col-sm-3">
									<select class="form-control m-b"  id="businesstype" name="businesstype">
										<option value="">--请选择--</option>
										<option value="001">保安服务公司许可证审批</option>
										<option value="002">保安培训机构许可证申请</option>
										<option value="003">保安服务公司设立分公司备案</option>
										<option value="004">保安员资格证考试报名</option>
										<option value="005">保安服务公司派出保安员跨省、自</br>治区、直辖市保安服务备案</option>
										<option value="006">自行招用保安员单位备案</option>
										<option value="007">保安服务（培训）许可证项目变更</option>
										<option value="008">保安公司年度报告备案</option>
										<option value="010">自行招用保安员单位撤销备案</option>
									</select>
								</div>
								<label class="col-sm-1 control-label">审批状态</label>
								<div class="col-sm-2">
									<select class="form-control m-b"  id="approvalstate" name="approvalstate">
										<option value="">--请选择--</option>
										<option value="004">审批不通过</option>
										<option value="003">审批通过</option>
										<option value="005">审批中</option>
										<option value="002">待审批</option>
									</select>
								</div>
								<div class="col-sm-2">
									<button class="btn btn-primary" type="button" onclick="reSearch();">搜索</button>
								</div>
							</div>
						</form>
						<c:if test="${police eq '1' and isAdmin eq '1' }">
							<c:if test="${LOGIN_USER.id eq '1047997'}">
								<div class="btn-group hidden-xs" id="tableEventsToolbar" role="group">
									<a href="<c:url value='/manage/approval/resetOldProcess.json?sid=${sid}'/>" target="ajaxTodo" title="确定旧流程转新流程?" class="btn btn-primary">
										旧流程转新流程
									</a>
								</div>
							</c:if>
						</c:if>
						<table id="defaultTable">
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
	<%@include file="/WEB-INF/views/include/foot.jsp"%>
	<script src="${ctxStatic }/js/plugins/bootstrap-table/bootstrap-table.min.js?v=${version}"></script>
	<script src="${ctxStatic }/js/plugins/bootstrap-table/locale/bootstrap-table-zh-CN.min.js?v=${version}"></script>
	<script src="${ctxStatic }/js/tablePage.js?v=${version}"></script>
	<script>
		$(function(){
			var objId = "defaultTable";
			var url = ctx + "/manage/approval/searchList.json?sid=${sid}";
			var columns = [  
					 {title: 'id',field: 'id', visible: false, align: 'center',valign: 'middle'},     
					 {title: '审批内容',field: 'context',align: 'center',valign: 'middle',sortable: true},
					 {title: '业务类型',field: 'businesstype',align: 'center',valign: 'middle',sortable: true,
                         formatter:function(value,row,index){
                             var html = '';
                             //业务类型
                             if (row.businesstype == "001") {
                                 html = '保安服务公司许可证审批';
                             } else if (row.businesstype == "002") {
                                 html = '保安培训机构许可证申请';
                             } else if (row.businesstype == "003") {
                                 html = '保安服务公司设立分公司备案';
                             } else if (row.businesstype == "004") {
                                 html = '保安员资格证考试报名';
                             } else if (row.businesstype == "005") {
                                 html = '保安服务公司派出保安员跨省、自</br>治区、直辖市保安服务备案';
                             } else if (row.businesstype == "006") {
                                 html = '自行招用保安员单位备案';
                             } else if (row.businesstype == "007") {
                                 html =legalchangeTile;
                             } else if (row.businesstype == "008") {
                                 html = '保安公司年度报告备案';
                             } else if (row.businesstype == "009") {
                                 html = '从事武装守护押运服务的保安员的枪支培训机构备案';
                             } else if (row.businesstype == "010") {
                                 html = '自行招用保安员单位撤销备案申请';
                             }

                             return html;
                         }
					 },
					 {title: '申请时间',field: 'create_time', align: 'center',valign: 'middle',sortable: true},
					 {title: '审批状态',field: 'approvalstate',align: 'center',valign: 'middle',sortable: true,
                         formatter:function(value,row,index){
                             //审核状态
                             var armtrainorgHtml = "";
                             if (row.approvalstate == "001") {
                                 armtrainorgHtml = '未提交';//审核状态
                             } else if (row.approvalstate == "002") {
                                 armtrainorgHtml = '待审批';//审核状态
                             } else if (row.approvalstate == "003") {
                                 armtrainorgHtml = '审批通过';//审核状态
                             } else if (row.approvalstate == "004") {
                                 armtrainorgHtml = '审批不通过';//审核状态
                             } else if (row.approvalstate == "005") {
                                 armtrainorgHtml = '审批中';//审核状态
                             } else if (row.approvalstate == "006") {
                                 armtrainorgHtml = '待批复';//审核状态
                             } else if (row.approvalstate == "008") {
                                 armtrainorgHtml = '上传批复材料';//审核状态
                             } else if (row.approvalstate == "010") {
                                 armtrainorgHtml = '许可';//审核状态
                             } else if (row.approvalstate == "011") {
                                 armtrainorgHtml = '不许可';//审核状态
                             } else if (row.approvalstate == "012") {
                                 armtrainorgHtml = '整改';//审核状态
                             } else if (row.approvalstate == "007") {
                                 armtrainorgHtml = '上传补全材料';//审核状态
                             } else {
                                 armtrainorgHtml = '';//审核状态
                             }

                             return armtrainorgHtml;
                         }
                     },
					 {title: '下一审批人',field: 'nextPerson',align: 'center',valign: 'middle',sortable: true},
					 {title: '操作',field: '#',align: 'center',
					     formatter:function(value,row,index){    
					       	 var d = '<a class="ml-10 btn btn-primary" href="'+ctx+'/manage/approval/repulseProcess/'+row.id+'.json?sid='+sid+'" target="ajaxTodo" title="确定流程打回?">流程打回</a>';
					       	 if(is_need_activitt =='0' && row.businesstype == "004"){
							 }else {
                                 d = d + '<a class="ml-10 btn btn-primary" href="' + ctx + '/manage/approval/reStartProcess/' + row.id + '.json?sid='+sid+'" target="ajaxTodo" title="确定重启流程?">重启流程</a>';
                                 d = d + '<a class="ml-10 btn btn-primary" href="' + ctx + '/manage/approval/jumpNextProcess/' + row.id + '.json?sid='+sid+'" target="ajaxTodo" title="确定跳到下一级?">跳到下一级</a>';
                             }
					       	 return d;
					     }   
					 }  
					];
			bootstrapTableDiy(objId,url,columns);

			initLayerBtnClick();
		})
	</script>
</body>
</html>
