package com.bcxin.ars.rest.util.manage;

import net.sf.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class ManageResultUtil {
	
	/**
	 * 返回 dwz 格式的json串（失败）
	 * 
	 * @param message
	 *            界面提示信息
	 * @param navTabId
	 *            重新载入标签页，如果无tabid参数，就载入当前标签页
	 * @param callbackType
	 *            callbackType如果是closeCurrent就会关闭当前tab
	 *            只有callbackType="forward"时需要forwardUrl值
	 * 
	 * @param forwardUrl
	 * @return JSON类型数据
	 */
	public static JSONObject returnFailedJson(String message,
			String navTabId,String callbackType,String forwardUrl) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("statusCode", "300");
		map.put("message", message);
		map.put("navTabId", navTabId );
		map.put("callbackType", callbackType );
		map.put("forwardUrl", forwardUrl );
		return JSONObject.fromObject(map);
	}
	
	/**
	 * 返回 dwz 格式的json串（成功）
	 * 
	 * @param message
	 *            界面提示信息
	 * @param navTabId
	 *            重新载入标签页，如果无tabid参数，就载入当前标签页
	 * @param callbackType
	 *            callbackType如果是closeCurrent就会关闭当前tab
	 *            只有callbackType="forward"时需要forwardUrl值
	 * 
	 * @param forwardUrl
	 * @return JSON类型数据
	 */
	public static JSONObject returnSuccessJson(String message,
			String navTabId,String callbackType,String forwardUrl,Object data) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("statusCode", "200");
		map.put("message", message);
		map.put("navTabId", navTabId );
		map.put("callbackType", callbackType );
		map.put("forwardUrl", forwardUrl );
		map.put("data", data);
		return JSONObject.fromObject(map);
	}

	public static JSONObject returnSuccessJson(String message, String navTabId,String callbackType,String forwardUrl ) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("statusCode", "200");
		map.put("message", message);
		map.put("navTabId", navTabId );
		map.put("callbackType", callbackType );
		map.put("forwardUrl", forwardUrl );
		return JSONObject.fromObject(map);
	}

}
