package com.bcxin.ars.rest.util;

import com.bcxin.ars.exception.ArsException;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.UnauthorizedException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Slf4j
public class ArsExceptionHandler implements HandlerExceptionResolver {
	
//	private Logger logger = Logger.getLogger(ArsExceptionHandler.class);

	@Override
	public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if(ex instanceof UnauthorizedException){
            ModelAndView mv = new ModelAndView("redirect:/refuse.json");  
            return mv;  
        }
        log.error(ex.getMessage());
        ModelAndView mv = new ModelAndView("error");
        mv.addObject("successful", false);
        mv.addObject("code", "");
     //   if(ex instanceof ArsException){
        	mv.addObject("msg", ex.getMessage());
       // }else{
        //	 mv.addObject("msg", "发生未知错误，请与系统管理员联系！");
            log.error(ex.getMessage());
        //}
        mv.addObject("data", ex.toString().replaceAll("\n", "<br/>"));
        return mv;  
    }  
	
}
