package com.bcxin.ars.rest.thirdParty.certificate;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SecurityCertificateInfoDto;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.sb.PersoncertificateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by yyx on 2020/5/15
 */

@Controller
@RequestMapping("thirdParty/certificatePerson")
public class CertificatePersonController {
    Logger logger = LoggerFactory.getLogger(CertificatePersonController.class);

    @Autowired
    private PersoncertificateService personcertificateService;
    @Autowired
    private SecurityCertificateService securityCertificateService;

    @RequestMapping("getSecurityCertificateInfo")
    @ResponseBody
    public AjaxResult getSecurityCertificateInfo(){
        AjaxResult ajaxResult = new AjaxResult();
        try {
            List<SecurityCertificateInfoDto> seCerInList = personcertificateService.findCertificate();
            if (seCerInList!=null && seCerInList.size()>0){
                ajaxResult.setSuccessful(true);
                ajaxResult.setData(seCerInList);
            }else {
                ajaxResult.setSuccessful(false);
                ajaxResult.setData("暂无抽取到信息");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return ajaxResult;
    }


    @RequestMapping("getCerInfoByIdNums")
    @ResponseBody
    public AjaxResult getCerInfoByIdNums(String[] idNums){
        AjaxResult ajaxResult = new AjaxResult();
        try {
            List<SecurityCertificateInfoDto> seCerInList = personcertificateService.findCerInfoByIdNums(idNums);
            if (seCerInList!=null && seCerInList.size()>0){
                ajaxResult.setSuccessful(true);
                ajaxResult.setData(seCerInList);
            }else {
                ajaxResult.setSuccessful(false);
                ajaxResult.setData("暂无相关信息");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return ajaxResult;
    }

    @RequestMapping("updateIsDraw")
    @ResponseBody
    public AjaxResult updateIsDraw(String[] idNums){
        AjaxResult ajaxResult = new AjaxResult();
        try {
            List<String> resultList = new ArrayList<>(Arrays.asList(idNums));
            List<String> failNumbers = securityCertificateService.updateIsDraw(resultList);
            if (failNumbers == null || failNumbers.size() ==0){
                ajaxResult.setSuccessful(true);
                ajaxResult.setMsg("更新成功！");
            }else {
                ajaxResult.setSuccessful(false);
                ajaxResult.setData(failNumbers.size()+"人更新失败！不存在库中的身份证号"+ JSONArray.toJSON(failNumbers));
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return ajaxResult;
    }


}
