package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.GradeSubsidyBatchPageSearchDto;
import com.bcxin.ars.model.sb.GradeSubsidyBatch;
import com.bcxin.ars.service.sb.GradeSubsidyBatchService;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 等级证补贴批次
 */
@Controller
@RequestMapping("gradeSubsidyBatch")
public class GradeSubsidyBatchController {

    @Autowired
    private GradeSubsidyBatchService gradeSubsidyBatchService;

    /**
     * Interface分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(GradeSubsidyBatchPageSearchDto dto, AjaxPageResponse<GradeSubsidyBatch> page){
        gradeSubsidyBatchService.searchForPageInterface(dto,page);
        return page;
    }

    /**
     * 修改补贴发放状态状态 为已发放
     */
    @RequestMapping("updateGrantState")
    @ResponseBody
    public AjaxResult updateGrantState(String id){
        AjaxResult result=new AjaxResult();
        gradeSubsidyBatchService.updateGrantState(id);
        result.setSuccessful(true);
        return  result;
    }
}
