package com.bcxin.ars.rest.msg;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.BaseController;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.ProblemPersonService;
import com.bcxin.ars.service.msg.NewsnoticeCompanyService;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/***
 * 公司消息通知信息控制层
 * @author subh
 * @see NewsnoticeCompanyService
 * @see ArsRestUtil
 */
@Controller
@RequestMapping("newsnoticecompany")
public class NewsnoticeCompanyController extends BaseController {
    /***
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(NewsnoticeCompanyController.class);
    @Autowired
    private NewsnoticeCompanyService newsnoticeCompanyService;
    @Autowired
    private ArsRestUtil arsUtil;
    @Autowired
    private ProblemPersonService problemPersonService;
    /**
     * 根据申请ID更新已读未读状态
     * @param newIds saas消息id列表
     * @param messageType 消息类型
     * @return
     * @throws Exception
     */
    @RequestMapping("updateReadstateByidArr")
    public @ResponseBody
        AjaxResult updateReadstateByidArr(Long[] newIds,String messageType) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                result.setSuccessful(true);
                switch (messageType){
                    case Constants.MESSAGETYPE_050301:
                        newsnoticeCompanyService.updateReadstateByidArr(newIds);
                        break;
                    case Constants.MESSAGETYPE_050302:
                        problemPersonService.updateReadstateByidArr(newIds);
                        break;
                    default:
                        break;
                }
                result.setSuccessful(true);
                result.setMsg("操作成功！");
            } else {
                result.setSuccessful(false);
                result.setMsg("找不到当前用户！");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
