package com.bcxin.ars.rest.gx;

import com.bcxin.ars.dto.gx.IntegratedApplyDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.gx.IntegratedResult;
import com.bcxin.ars.service.gx.IntegratedService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 广西公安互联网+平台推送流水号到业务办理系统
 * @author subh
 * @since jdk1.8
 * @see IntegratedService
 * @see LoggerFactory
 */
@Controller
@RequestMapping("integrated")
public class IntegratedController {
    /**
     * 日志
     */
    private final static Logger logger = LoggerFactory.getLogger(IntegratedController.class);
    /***
     * 一体化服务层
     */
    @Autowired
    private IntegratedService integratedService;
    /**
     * 广西公安互联网+平台推送流水号到业务办理系统新增
     * @param dto  一体化流水号表单数据
     * @return 返回执行结果对象
     * @throws Exception  系统异常
     */
    @RequestMapping(value= "/sendAppNo")
    public @ResponseBody
    IntegratedResult save(IntegratedApplyDto dto){
        IntegratedResult result = new IntegratedResult();
        try {
            //保存广西公安互联网+平台推送流水号信息
            integratedService.save(dto);
            //成功标记
            result.setStatus(IntegratedResult.SUCCESS);
            //成功提示信息
            result.setDesc(IntegratedResult.SUCCESS_MES);
            //当前日期
            result.setTime(DateUtil.getCurrentDate(DateUtil.FORMAT8));
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            dto.setExceptionContext(e.getMessage());
            //业务异常
            if(e instanceof ArsException){
                //错误信息
                result.setDesc(e.getMessage());
            }else{
                //系统异常
                result.setDesc(Constants.SYSTEM_ERROR_MSG);
            }
            //失败标记
            result.setStatus(IntegratedResult.ERROR);
        }finally {
            //保存日志
            integratedService.saveLog(dto);
        }

        return result;
    }
    /**
     * 广西公安互联网+平台获取Token
     * @return 返回执行结果对象
     * @throws Exception  系统异常
     */
    @RequestMapping(value= "/getToken" )
    public @ResponseBody
    IntegratedResult getToken(){
        IntegratedResult result = new IntegratedResult();
        try {
            //保存广西公安互联网+平台推送流水号信息
            result =  integratedService.getToken();
            //成功标记
            result.setStatus(IntegratedResult.SUCCESS);
            //当前日期
            result.setTime(DateUtil.getCurrentDate(DateUtil.FORMAT8));
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            //业务异常
            if(e instanceof ArsException){
                //错误信息
                result.setDesc(e.getMessage());
            }else{
                //系统异常
                result.setDesc(Constants.SYSTEM_ERROR_MSG);
            }
            //失败标记
            result.setStatus(IntegratedResult.ERROR);
        }
        return result;
    }



    /**
     * 广西公安互联网+平台验证公司名称是否存在
     * @return 返回执行结果对象
     * @throws Exception  系统异常
     */
    @RequestMapping(value= "/checkCompanyName" )
    public @ResponseBody
    IntegratedResult checkCompanyName(IntegratedApplyDto dto){
        IntegratedResult result = new IntegratedResult();
        try {
            //保存广西公安互联网+平台推送流水号信息
            integratedService.checkCompanyName(dto);
            //成功标记
            result.setStatus(IntegratedResult.SUCCESS);
            //当前日期
            result.setTime(DateUtil.getCurrentDate(DateUtil.FORMAT8));
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            dto.setExceptionContext(e.getMessage());
            //业务异常
            if(e instanceof ArsException){
                //错误信息
                result.setDesc(e.getMessage());
            }else{
                //系统异常
                result.setDesc(Constants.SYSTEM_ERROR_MSG);
            }
            //失败标记
            result.setStatus(IntegratedResult.ERROR);
        }
        //保存日志
        integratedService.saveLog(dto);
        return result;
    }
}
