package com.bcxin.ars.rest.gx;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.gx.FingerDTO;
import com.bcxin.ars.dto.gx.IntegratedApplyDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.gx.IntegratedResult;
import com.bcxin.ars.service.gx.FingerService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("finger")
public class FingerController {
    /**
     * 日志
     */
    Logger logger = LoggerFactory.getLogger(FingerController.class);
    /**
     * 广西现场采集指纹服务层
     */
    @Autowired
    private FingerService fingerService;
    /**
     * 广西现场采集指纹保存
     * @param dto 指纹信息
     * @return 保存结果
     */
    @RequestMapping(value= "/save" )
    public @ResponseBody AjaxResult save(FingerDTO dto){
        AjaxResult result = new AjaxResult();
        try {
            fingerService.save(dto);
            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            //业务异常
            if(e instanceof ArsException){
                //错误信息
                result.setMsg(e.getMessage());
            }
        }
        return result;
    }
}
