package com.bcxin.ars.rest.datasync;

import com.bcxin.ars.dto.datasync.DataSyncDto;
import com.bcxin.ars.dto.datasync.DataSyncResultDto;
import com.bcxin.ars.model.datasync.DataSyncLog;
import com.bcxin.ars.service.datasync.DataSyncLogService;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;


/**
 * 数据同步记录Controller
 * 
 * @author lin
 * @date 2020-12-07
 */
@Controller
@RequestMapping("/dataSync")
public class DataSyncController {
    Logger logger = LoggerFactory.getLogger(DataSyncController.class);

    @Autowired
    private DataSyncLogService dataSyncLogService;

    /**
     * 同步
     * @param dataSyncDto
     * @return
     */
    @RequestMapping("receive")
    @ResponseBody
    public DataSyncResultDto receive(DataSyncDto dataSyncDto){
        DataSyncResultDto result = new DataSyncResultDto();
        try {
            dataSyncLogService.receive(dataSyncDto);
            result.setRetType(Constants.RETTYPE_SUCCESS);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setRetType(Constants.RETTYPE_FAIL);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    /**
     * 同步回调
     * @param dataSyncLog
     * @return
     */
    @RequestMapping("callback")
    @ResponseBody
    public DataSyncResultDto callback(DataSyncLog dataSyncLog){
        DataSyncResultDto result = new DataSyncResultDto();
        try {
            dataSyncLogService.callback(dataSyncLog);
            result.setRetType(Constants.RETTYPE_SUCCESS);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setRetType(Constants.RETTYPE_FAIL);
            result.setMsg(e.getMessage());
        }
        return result;
    }

}
