package com.bcxin.ars.rest.app;

import com.bcxin.ars.rest.dto.AppAjaxResult;
import com.bcxin.ars.service.sys.SyscodeService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * Created by lenovo on 2017/5/7.
 */
@Controller
@RequestMapping(value = "app/sys/code")
public class AppSyscodeController {

    private static final Logger logger = LoggerFactory.getLogger(AppSyscodeController.class);
    @Autowired
    private SyscodeService codeService;

    @RequestMapping(value = "/findAll")
    @ResponseBody
    public AppAjaxResult findAll() throws Exception {
        AppAjaxResult result = new AppAjaxResult();
        try {
            result.setSuccessful(true);
            result.setEncodeData(codeService.findAll());
        } catch(Exception e) {
            throw e;
        }
        return result;
    }

}
