package com.bcxin.ars.rest.app;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.model.task.AppServicePersonCategory;
import com.bcxin.ars.rest.dto.AppAjaxResult;
import com.bcxin.ars.service.task.AppServicePersonCategoryService;
/**
 * 个人服务窗列表
 * @author zhangye
 */
@Controller
@RequestMapping("app/service/person")
public class AppServicePersonController {
	
	private static final Logger logger = LoggerFactory.getLogger(AppServicePersonController.class);
	
	@Autowired
	private AppServicePersonCategoryService appServicePersonCategoryService;
	
	 
	/**
	 * 查询
	 * @return
	 */
	@RequestMapping("v-1-0-9/category/findpersonservicelist")
	public @ResponseBody AppAjaxResult findAppPersonServiceList() throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			AppServicePersonCategory appServicePersonCategory =  new AppServicePersonCategory();
			List<AppServicePersonCategory> list = appServicePersonCategoryService.findList(appServicePersonCategory);
			result.setSuccessful(true);
			result.setEncodeData(list);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	 
}
