package com.bcxin.ars.rest.app;

import com.bcxin.ars.model.CityConfig;
import com.bcxin.ars.rest.dto.AppAjaxResult;
import com.bcxin.ars.service.CityConfigService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
/**
 * Created by lenovo on 2017/6/4.
 */
@Controller
@RequestMapping("app/cityConfig")
public class AppCityConfigController {
    private Logger logger = LoggerFactory.getLogger(AppCityConfigController.class);
    @Autowired
    private CityConfigService cityConfigService;
    /***
     * 获取城市列表
     * @return
     */
    @RequestMapping("findAll")
    public @ResponseBody
    AppAjaxResult findAll() throws Exception {
        AppAjaxResult result = new AppAjaxResult();
        try {
            List<CityConfig> list =cityConfigService.findAll();
            result.setSuccessful(true);
            result.setEncodeData(list);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
