package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ValidateException;
import com.bcxin.ars.service.ThirdTrainBackgroundService;
import com.bcxin.ars.service.appeal.AppealService;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.sb.GradeClassService;
import com.bcxin.ars.service.sb.GradeSubsidyBatchService;
import com.bcxin.ars.service.sb.PersonGradeService;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.service.subsidy.GradeSubsidyRosterService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author zhangyutong
 */
@RestController
@RequestMapping("thirdTrain")
public class ThirdTrainController {

    @Resource
    private SecurityCertificateService securityCertificateService;

    @Resource
    private ThirdTrainBackgroundService thirdTrainBackgroundService;

    @Resource
    private GradeClassService gradeClassService;

    @Resource
    private GradeSubsidyRosterService gradeSubsidyRosterService;

    @Resource
    private GradeSubsidyBatchService gradeSubsidyBatchService;

    @Resource
    private AppealService appealService;

    @Resource
    private PersoncertificateService personcertificateService;

    @Resource
    private PersonGradeService personGradeService;

    @RequestMapping("canSignUpSecurityCertificate")
    public AjaxResult canSignUpSecurityCertificate(String idNumbers) {
        return securityCertificateService.canSignUpSecurityCertificate(idNumbers);
    }

    @RequestMapping("canSignUpGradeCertificate")
    public AjaxResult canSignUpGradeCertificate(String idNumbers) {
        return personGradeService.canSignUpGradeCertificate(idNumbers);
    }

    @RequestMapping("signUpSecurityCertificate")
    public AjaxResult signUpSecurityCertificate(String securityCertificates) {
        return personcertificateService.signUpSecurityCertificate(securityCertificates);
    }

//    @RequestMapping("commitPeopleBackgroundScreening")
    public AjaxResult commitPeopleBackgroundScreening(String thirdTrainBackgrounds) {
        return thirdTrainBackgroundService.commitPeopleBackgroundScreening(thirdTrainBackgrounds);
    }

    @RequestMapping("listPeopleBackgroundScreening")
    public AjaxResult listPeopleBackgroundScreening(String thirdTrainBackground) {
        return thirdTrainBackgroundService.listPeopleBackgroundScreening(thirdTrainBackground);
    }

    @RequestMapping("commitGradeClassRequest")
    public AjaxResult commitGradeClassRequest(String gradeClassInfo) {
        return gradeClassService.addGradeClassRequest(gradeClassInfo);
    }

    @RequestMapping("getGradeClassRequestResult")
    public AjaxResult getGradeClassRequestResult(String gradeClassName) {
        return gradeClassService.getGradeClassRequestResult(gradeClassName);
    }

    @RequestMapping("addGradeClassPerson")
    public AjaxResult addGradeClassPerson(String gradeClass) {
        return gradeClassService.addGradeClassPerson(gradeClass);
    }

    @RequestMapping("removeGradeClassPerson")
    public AjaxResult removeGradeClassPerson(String gradeClass) {
        return gradeClassService.removeGradeClassPerson(gradeClass);
    }

    @RequestMapping("commitGradeClassAdditionalInfo")
    public AjaxResult commitGradeClassAdditionalInfo(String gradeClass) {
        return gradeClassService.commitGradeClassAdditionalInfo(gradeClass);
    }

    @RequestMapping("confirmGradeResult")
    public AjaxResult confirmGradeResult(String gradeResult) {
        return gradeClassService.confirmGradeResult(gradeResult);
    }

    @RequestMapping("listPersonnelSubsidyApplicationStatus")
    public AjaxResult listPersonnelSubsidyApplicationStatus(String gradeSubsidyRoster) {
        return gradeSubsidyRosterService.listPersonnelSubsidyApplicationStatus(gradeSubsidyRoster);
    }

    @RequestMapping("subsidyApplicationStatusInquiry")
    public AjaxResult subsidyApplicationStatusInquiry(String batchNameSubject) {
        return gradeSubsidyBatchService.subsidyApplicationStatusInquiry(batchNameSubject);
    }

    @RequestMapping("newSubsidyApplication")
    public AjaxResult newSubsidyApplication(String gradeSubsidyBatchInfo) {
        return gradeSubsidyBatchService.newSubsidyApplication(gradeSubsidyBatchInfo);
    }

    @RequestMapping("submitBackgroundAppeal")
    public AjaxResult submitBackgroundAppeal(String appeal) {
        return appealService.submitBackgroundAppeal(appeal);
    }

    @RequestMapping("queryBackgroundAppealResult")
    public AjaxResult queryBackgroundAppealResult(String appealId) {
        return appealService.queryBackgroundAppealResult(appealId);
    }

    @RequestMapping("personCertificateApply")
    public AjaxResult personCertificateApply(String personCertificates) throws ValidateException {
        return personcertificateService.personCertificateApply(personCertificates);
    }

    @RequestMapping("gradeCertificateApply")
    public AjaxResult gradeCertificateApply(String gradeCertificate) {
        return personGradeService.gradeCertificateApply(gradeCertificate);
    }

    @RequestMapping("syncGradeCertificateInformation")
    public AjaxResult syncGradeCertificateInformation(String personGrades) {
        return personGradeService.syncGradeCertificateInformation(personGrades);
    }

    @RequestMapping("cancelPersonCertificateApply")
    public AjaxResult cancelPersonCertificateApply(String personCertificateId) {
        return personcertificateService.cancelPersonCertificateApply(personCertificateId);
    }

    @RequestMapping("cancelGradeCertificateApply")
    public AjaxResult cancelGradeCertificateApply(String gradeCertificateId) {
        return personGradeService.cancelGradeCertificateApply(gradeCertificateId);
    }
}
