package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SecurityTraincompanySearchDto;
import com.bcxin.ars.model.SecurityTraincompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SecurityTraincompanyService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.Valid;

@Controller
@RequestMapping("securityTraincompany")
public class SecurityTraincompanyController {

	Logger logger = LoggerFactory.getLogger(SecurityTraincompanyController.class);
	
	@Autowired
	private SecurityTraincompanyService securityTraincompanyService;
	
	@Autowired
	private ArsUtil arsUtil;

	@RequestMapping("update")
	public @ResponseBody AjaxResult update(@Valid SecurityTraincompany securityTraincompany) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				securityTraincompanyService.saveOrUpdate(securityTraincompany);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(SecurityTraincompany securityTraincompany) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				securityTraincompanyService.delete(securityTraincompany);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
}
