package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.service.ProblemPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("problemperson")
public class ProblemPersonController {

	/***
	 * 日志
	 */
	private static final Logger logger = LoggerFactory.getLogger(ProblemPersonController.class);
	
	@Autowired
	private ProblemPersonService problemPersonService;

    /***
     * 待处理问题人员数量
     * @param
     * @return
     * @throws Exception
     */
    @RequestMapping("getUnDisposeQty")
    public @ResponseBody AjaxResult getUnDisposeQty() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
			result.setData(problemPersonService.getUnDisposeQty());
            result.setSuccessful(true);
            return result;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }

    }
}
