package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.TaskSearchDto;
import com.bcxin.ars.model.Invoice;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.InvoiceService;
import com.bcxin.ars.service.SecurityPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 发票Controller
 * @author liumd
 * @createTime 2017年4月5日
 */
@Controller
@RequestMapping("invoice")
public class InvoiceController {
	
	private Logger logger = LoggerFactory.getLogger(InvoiceController.class);
	
	@Autowired
	private InvoiceService invoiceService;
	
	@Autowired
	private ArsRestUtil arsUtil;

	@Autowired
	private SecurityPersonService personService;
	
	
	@ResponseBody
	@RequestMapping("save")
	public AjaxResult save(Invoice invoice) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User currentUser = arsUtil.getCurrentUser();
			
	        User user = currentUser;
			invoiceService.saveOrUpdate(invoice,user);
			result.setMsg("更新成功");
			result.setSuccessful(true);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	
	@ResponseBody
	@RequestMapping("getMsg")
	public AjaxResult getMsg() throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User currentUser = arsUtil.getCurrentUser();
			
	        User user = currentUser;
			Invoice invoice = invoiceService.getMsg(user.getId());
			result.setData(invoice);
			result.setSuccessful(true);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	
	/**
	 * 获取发票列表
	 * 暂时不提供搜索功能
	 * @return
	 */
	@ResponseBody
	@RequestMapping("search")
	public AjaxResult search(TaskSearchDto dto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<Invoice> lis = invoiceService.getInvoiceList();
			result.setSuccessful(true);
			result.setData(lis);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	
	
	
}
