package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.CyServerhtSearchDto;
import com.bcxin.ars.model.CyServerht;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.CyServerhtService;
import com.bcxin.ars.service.SecurityPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.Valid;


/**
 * 服务合同
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年8月1日 下午2:29:20
 * @注意事项 </b>
 * <b>
 */

@Controller
@RequestMapping("cyServerht")
public class CyserverhtController {
	
	private static final Logger logger = LoggerFactory.getLogger(CyserverhtController.class);
	
	@Autowired
	private CyServerhtService cyServerhtService;


	/**
	 * 创建或更新服务合同信息
	 * @param cyServerht 服务合同信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(@Valid CyServerht cyServerht) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			cyServerhtService.saveOrUpdate(cyServerht);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 删除服务合同信息
	 * @return
	 */
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			CyServerht cyServerht = cyServerhtService.findById(id);

			if(cyServerht != null) {
				cyServerhtService.delete(cyServerht);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 解除合同
	 * <b>Function </b> 
	 * 
	 * @param htId
	 * @return
	 * @author LinQingLin 
	 * @date 2017年5月19日 下午7:51:23
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("relieveHt")
	public @ResponseBody AjaxResult relieveHt(Long htId) throws Exception {
		try {
			return cyServerhtService.relieveHt(htId);
		} catch (Exception e) {
			throw e;
		}
	}
}
