package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.CyAssociation;
import com.bcxin.ars.service.CyAssociationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;


@Controller
@RequestMapping("cyAssociation")
public class CyAssociationController {
	
	private static final Logger logger = LoggerFactory.getLogger(CyAssociationController.class);
	
	@Autowired
	private CyAssociationService cyAssociationService;


	/**
	 * 创建或更新保安协会管理信息
	 * @param cyAssociation 保安协会管理信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(CyAssociation cyAssociation) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			cyAssociationService.save(cyAssociation);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	/**
	 * 删除保安协会管理信息
	 * @return
	 */
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			CyAssociation cyAssociation = cyAssociationService.findById(id);

			if(cyAssociation != null) {
				cyAssociationService.delete(cyAssociation);
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
				result.setMsg("删除信息失败，ID:" + id);
			}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取保安协会管理信息
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			CyAssociation cyAssociation = cyAssociationService.findById(id);
			result.setSuccessful(true);
			result.setData(cyAssociation);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
