package com.bcxin.ars.rabbitmq;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import java.util.UUID;

/**
 * 生产者
 * @author linqinglin
 * @date 2018/12/15 0015 10:39
 */
@Component
public class RabbitProducer implements RabbitTemplate.ConfirmCallback{

    private Logger logger = LoggerFactory.getLogger(RabbitProducer.class);


    @Autowired
    private Environment env;

    @Autowired
    private RabbitTemplate rabbitTemplate;

    public void sendMsg(String content) {
        CorrelationData correlationId = new CorrelationData(UUID.randomUUID().toString());
        this.rabbitTemplate.setConfirmCallback(this);
        this.rabbitTemplate.convertAndSend(env.getProperty("rabbitmq.exchange"),env.getProperty("rabbitmq.routingKey"), content, correlationId);
    }

    @Override
    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        logger.info(" 回调id:" + correlationData);
        if (ack) {
            logger.info("消息成功消费");
        } else {
            logger.info("消息消费失败:" + cause);
        }
    }
}
