/*
 * Decompiled with CFR 0.152.
 */
package com.abcxin.smart.validator.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.ibatis.mapping.ParameterMapping;

public class JsqlparserUtil {
    private static CCJSqlParserManager parser = new CCJSqlParserManager();

    private JsqlparserUtil() {
    }

    public static void main(String[] args) throws Exception {
        String sql = "select aa,(select bb from cc where dd >1) as ee from ff,dd left join aad on ada=adsfasd where gg=1";
        System.out.println(JsqlparserUtil.getCountSql(sql, null));
    }

    public static void parser(String sql) throws JSQLParserException {
        long time1 = System.currentTimeMillis();
        System.out.println(sql);
        Update updateStatement = JsqlparserUtil.getUpdateStatement(sql);
        long time2 = System.currentTimeMillis();
        System.out.println("\u5f53\u524d\u7a0b\u5e8f\u8017\u65f6\uff1a" + (time2 - time1) + "ms");
    }

    public static Update getUpdateStatement(String sql) throws JSQLParserException {
        Statement statement = parser.parse((Reader)new StringReader(sql));
        if (statement instanceof Update) {
            return (Update)statement;
        }
        return null;
    }

    public static List<String> getTableNames(String sql) throws JSQLParserException {
        Statement statement = parser.parse((Reader)new StringReader(sql));
        return JsqlparserUtil.getTableNames((Update)statement, sql);
    }

    public static List<String> getTableNames(Update updateStatement, String sql) throws JSQLParserException {
        TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
        return tablesNamesFinder.getTableList((Statement)updateStatement);
    }

    public static Map<String, String> getSetColumnNames(String sql) throws JSQLParserException {
        Statement statement = parser.parse((Reader)new StringReader(sql));
        if (statement instanceof Update) {
            Update updateStatement = (Update)statement;
            return JsqlparserUtil.getSetColumns(updateStatement, sql);
        }
        return null;
    }

    public static Map<String, String> getSetColumns(Update updateStatement, String sql) throws JSQLParserException {
        if (updateStatement != null) {
            HashMap<String, String> allColumnNames = new HashMap<String, String>();
            List columns = updateStatement.getColumns();
            List values = updateStatement.getExpressions();
            for (int i = 0; i < columns.size(); ++i) {
                allColumnNames.put(((Column)columns.get(i)).getColumnName(), ((Expression)values.get(i)).toString());
            }
            return allColumnNames;
        }
        return null;
    }

    public static String getQuerySql(String sql) throws JSQLParserException {
        Statement statement = parser.parse((Reader)new StringReader(sql));
        if (statement instanceof Update) {
            Update updateStatement = (Update)statement;
            return JsqlparserUtil.getQuerySql(updateStatement, sql);
        }
        return null;
    }

    public static String getQuerySql(Update updateStatement, String sql) throws JSQLParserException {
        if (updateStatement != null) {
            List<String> tableNames = JsqlparserUtil.getTableNames(updateStatement, sql);
            StringBuffer querySql = new StringBuffer();
            querySql.append("select ");
            List columns = updateStatement.getColumns();
            querySql.append(" " + columns.toString().replaceAll("\\[", "").replaceAll("]", ""));
            querySql.append(" from " + tableNames.toString().toLowerCase().replaceAll("\\[", "").replaceAll("]", ""));
            Expression where = updateStatement.getWhere();
            querySql.append(" where " + where.toString().toLowerCase());
            return querySql.toString();
        }
        return null;
    }

    public static Map<String, String> getWhereColumns(String sql) throws JSQLParserException {
        Statement statement = parser.parse((Reader)new StringReader(sql));
        if (statement instanceof Update) {
            Update updateStatement = (Update)statement;
            JsqlparserUtil.getWhereColumns(updateStatement, sql);
        }
        return null;
    }

    public static Map<String, String> getWhereColumns(Update updateStatement, String sql) throws JSQLParserException {
        if (updateStatement != null) {
            Expression where = updateStatement.getWhere();
            HashMap<String, String> allColumnNames = new HashMap<String, String>();
            if (where instanceof BinaryExpression) {
                return JsqlparserUtil.getColumnName((Expression)((BinaryExpression)where), allColumnNames);
            }
        }
        return null;
    }

    private static Map<String, String> getColumnName(Expression expression, Map<String, String> allColumnNames) {
        String columnName = null;
        if (expression instanceof BinaryExpression) {
            Expression leftExpression = ((BinaryExpression)expression).getLeftExpression();
            Expression rightExpression = ((BinaryExpression)expression).getRightExpression();
            if (leftExpression instanceof Column) {
                columnName = ((Column)leftExpression).getColumnName();
                allColumnNames.put(columnName.toLowerCase(), rightExpression.toString());
            } else if (leftExpression instanceof BinaryExpression) {
                JsqlparserUtil.getColumnName((Expression)((BinaryExpression)leftExpression), allColumnNames);
            }
            if (rightExpression instanceof BinaryExpression) {
                Expression leftExpression2 = ((BinaryExpression)rightExpression).getLeftExpression();
                Expression rightExpression2 = ((BinaryExpression)rightExpression).getRightExpression();
                if (leftExpression2 instanceof Column) {
                    columnName = ((Column)leftExpression2).getColumnName();
                    allColumnNames.put(columnName.toLowerCase(), rightExpression2.toString());
                }
            }
        }
        return allColumnNames;
    }

    public static String getCountSql(String sql, List<ParameterMapping> params) throws Exception {
        Statement statement = parser.parse((Reader)new StringReader(sql));
        StringBuilder countSql = new StringBuilder("SELECT COUNT(1) FROM ");
        if (statement instanceof Select) {
            Select select = (Select)statement;
            PlainSelect selectBody = (PlainSelect)select.getSelectBody();
            for (SelectItem selectItem : selectBody.getSelectItems()) {
                String[] split = selectItem.toString().split("\\?");
                if (split.length <= 1) continue;
                for (int i = 1; i < split.length; ++i) {
                    params.remove(0);
                }
            }
            countSql.append(selectBody.getFromItem() + " ");
            if (selectBody.getJoins() != null) {
                for (Join join : selectBody.getJoins()) {
                    if (join.isSimple()) {
                        countSql.append(", ");
                    }
                    countSql.append(join.toString() + " ");
                }
            }
            if (selectBody.getWhere() != null) {
                countSql.append("WHERE " + selectBody.getWhere());
            }
        }
        return countSql.toString();
    }
}

